/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.jta.utils;

import com.arjuna.ats.jta.common.jtaPropertyManager;
import com.arjuna.ats.jta.logging.jtaLogger;
import javax.naming.ConfigurationException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.naming.Reference;

public class JNDIManager {
    public static void bindJTAImplementations(InitialContext ctx) throws NamingException {
        JNDIManager.bindJTATransactionManagerImplementation(ctx);
        JNDIManager.bindJTAUserTransactionImplementation(ctx);
        JNDIManager.bindJTATransactionSynchronizationRegistryImplementation(ctx);
    }

    public static void bindJTAImplementation() throws NamingException {
        JNDIManager.bindJTATransactionManagerImplementation();
        JNDIManager.bindJTAUserTransactionImplementation();
        JNDIManager.bindJTATransactionSynchronizationRegistryImplementation();
    }

    public static String getTransactionManagerImplementationClassname() {
        return jtaPropertyManager.getJTAEnvironmentBean().getJtaTMImplementation();
    }

    public static String getUserTransactionImplementationClassname() {
        return jtaPropertyManager.getJTAEnvironmentBean().getJtaUTImplementation();
    }

    public static String getTransactionSynchronizationRegistryImplementationClassname() {
        return jtaPropertyManager.getJTAEnvironmentBean().getJtaTSRImplementation();
    }

    public static void bindJTATransactionManagerImplementation() throws NamingException {
        JNDIManager.bindJTATransactionManagerImplementation(new InitialContext());
    }

    public static void unbindJTATransactionManagerImplementation() throws NamingException {
        JNDIManager.unbindJTATransactionManagerImplementation(new InitialContext());
    }

    public static void bindJTATransactionManagerImplementation(InitialContext initialContext) throws NamingException {
        String tmImplementation = JNDIManager.getTransactionManagerImplementationClassname();
        Reference ref = new Reference(tmImplementation, tmImplementation, null);
        initialContext.rebind(JNDIManager.getTransactionManagerJNDIName(), (Object)ref);
    }

    public static void unbindJTATransactionManagerImplementation(InitialContext initialContext) throws NamingException {
        initialContext.unbind(JNDIManager.getTransactionManagerJNDIName());
    }

    public static void bindJTAUserTransactionImplementation() throws NamingException {
        JNDIManager.bindJTAUserTransactionImplementation(new InitialContext());
    }

    public static void bindJTAUserTransactionImplementation(InitialContext initialContext) throws NamingException {
        String utImplementation = JNDIManager.getUserTransactionImplementationClassname();
        Reference ref = new Reference(utImplementation, utImplementation, null);
        initialContext.rebind(JNDIManager.getUserTransactionJNDIName(), (Object)ref);
    }

    public static void bindJTATransactionSynchronizationRegistryImplementation() throws NamingException {
        JNDIManager.bindJTATransactionSynchronizationRegistryImplementation(new InitialContext());
    }

    public static void unbindJTATransactionSynchronizationRegistryImplementation() throws NamingException {
        JNDIManager.unbindJTATransactionSynchronizationRegistryImplementation(new InitialContext());
    }

    public static void bindJTATransactionSynchronizationRegistryImplementation(InitialContext initialContext) throws NamingException {
        String tsrImplementation = JNDIManager.getTransactionSynchronizationRegistryImplementationClassname();
        Object tsr = null;
        try {
            tsr = Class.forName(tsrImplementation).newInstance();
        }
        catch (Exception e) {
            ConfigurationException namingException = new ConfigurationException(jtaLogger.logMesg.getString("com.arjuna.ats.jta.utils.JNDIManager.tsr1"));
            namingException.setRootCause(e);
            throw namingException;
        }
        initialContext.rebind(JNDIManager.getTransactionSynchronizationRegistryJNDIName(), tsr);
    }

    public static void unbindJTATransactionSynchronizationRegistryImplementation(InitialContext initialContext) throws NamingException {
        initialContext.unbind(JNDIManager.getTransactionSynchronizationRegistryJNDIName());
    }

    public static final String getTransactionManagerJNDIName() {
        return jtaPropertyManager.getJTAEnvironmentBean().getJtaTMJNDIContext();
    }

    public static final String getUserTransactionJNDIName() {
        return jtaPropertyManager.getJTAEnvironmentBean().getJtaUTJNDIContext();
    }

    private static final String getTransactionSynchronizationRegistryJNDIName() {
        return jtaPropertyManager.getJTAEnvironmentBean().getJtaTSRJNDIContext();
    }
}

