/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.txoj;

import com.arjuna.ats.arjuna.StateManagerAttribute;
import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.arjuna.coordinator.AbstractRecord;
import com.arjuna.ats.arjuna.coordinator.BasicAction;
import com.arjuna.ats.arjuna.exceptions.FatalError;
import com.arjuna.ats.txoj.CadaverLockManager;
import com.arjuna.ats.txoj.LockManager;
import com.arjuna.ats.txoj.LockRecord;
import com.arjuna.ats.txoj.lockstore.LockStore;
import com.arjuna.ats.txoj.logging.txojLogger;
import java.io.PrintWriter;

class CadaverLockRecord
extends LockRecord {
    private LockStore cadaverLockStore;
    private String objectTypeName;
    private boolean doRelease;

    public CadaverLockRecord(LockStore store, LockManager lm, BasicAction currAct) {
        super(lm, currAct);
        this.cadaverLockStore = store;
        this.objectTypeName = new String(lm.type());
        this.doRelease = ((StateManagerAttribute)lm.attributes()).objectModel != 0;
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(1L, 4L, 10L, "CadaverLockRecord::CadaverLockRecord(" + store + ", " + (lm != null ? lm.get_uid() : Uid.nullUid()) + ")");
        }
    }

    @Override
    public boolean propagateOnAbort() {
        return true;
    }

    @Override
    public int nestedAbort() {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(16L, 4L, 10L, "CadaverLockRecord::nestedAbort() for " + this.order());
        }
        if (this.doRelease) {
            CadaverLockManager manager = new CadaverLockManager(this.order(), this.objectTypeName);
            if (this.actionHandle == null) {
                if (txojLogger.aitLoggerI18N.isFatalEnabled()) {
                    txojLogger.aitLoggerI18N.fatal("CadaverLockRecord_1");
                }
                throw new FatalError(txojLogger.log_mesg.getString("com.arjuna.ats.txoj.CadaverLockRecord_1"));
            }
            return manager.releaseAll(this.actionHandle.get_uid()) ? 7 : 8;
        }
        return 7;
    }

    @Override
    public int nestedCommit() {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(16L, 4L, 10L, "CadaverLockRecord::nestedCommit() for " + this.order());
        }
        if (this.doRelease) {
            if (this.actionHandle == null) {
                if (txojLogger.aitLoggerI18N.isFatalEnabled()) {
                    txojLogger.aitLoggerI18N.fatal("com.arjuna.ats.txoj.CadaverLockRecord_2");
                }
                throw new FatalError(txojLogger.log_mesg.getString("com.arjuna.ats.txoj.CadaverLockRecord_2"));
            }
            CadaverLockManager manager = new CadaverLockManager(this.order(), this.objectTypeName);
            return manager.propagate(this.actionHandle.get_uid(), this.actionHandle.parent().get_uid()) ? 7 : 8;
        }
        return 7;
    }

    @Override
    public int topLevelAbort() {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(16L, 4L, 10L, "CadaverLockRecord::topLevelAbort() for " + this.order());
        }
        if (this.doRelease) {
            if (this.actionHandle == null) {
                if (txojLogger.aitLoggerI18N.isFatalEnabled()) {
                    txojLogger.aitLoggerI18N.fatal("com.arjuna.ats.txoj.CadaverLockRecord_3");
                }
                throw new FatalError(txojLogger.log_mesg.getString("com.arjuna.ats.txoj.CadaverLockRecord_3"));
            }
            CadaverLockManager manager = new CadaverLockManager(this.order(), this.objectTypeName);
            return manager.releaseAll(this.actionHandle.get_uid()) ? 7 : 8;
        }
        return 7;
    }

    @Override
    public int topLevelCommit() {
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(16L, 4L, 10L, "CadaverLockRecord::topLevelCommit() for " + this.order());
        }
        if (this.doRelease) {
            if (this.actionHandle == null) {
                if (txojLogger.aitLoggerI18N.isFatalEnabled()) {
                    txojLogger.aitLoggerI18N.fatal("com.arjuna.ats.txoj.CadaverLockRecord_4");
                }
                throw new FatalError(txojLogger.log_mesg.getString("com.arjuna.ats.txoj.CadaverLockRecord_4"));
            }
            CadaverLockManager manager = new CadaverLockManager(this.order(), this.objectTypeName);
            return manager.releaseAll(this.actionHandle.get_uid()) ? 7 : 8;
        }
        return 7;
    }

    @Override
    public void print(PrintWriter strm) {
        strm.println("CadaverLockRecord : ");
        super.print(strm);
    }

    @Override
    public String type() {
        return "/StateManager/AbstractRecord/LockRecord/CadaverLockRecord";
    }

    @Override
    public boolean shouldReplace(AbstractRecord ar) {
        return this.order().equals(ar.order()) && ar.typeIs() == 121;
    }

    @Override
    public void replace(AbstractRecord ar) {
        LockRecord lr = (LockRecord)ar;
        this.objectTypeName = lr.lockType();
    }

    protected CadaverLockRecord() {
        this.cadaverLockStore = null;
        this.objectTypeName = null;
        this.doRelease = false;
        if (txojLogger.aitLogger.isDebugEnabled()) {
            txojLogger.aitLogger.debug(1L, 2L, 10L, "CadaverLockRecord::CadaverLockRecord ()");
        }
    }
}

