/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.common.internal.util.propertyservice;

import com.arjuna.common.internal.util.propertyservice.ConcatenationPrefix;
import com.arjuna.common.internal.util.propertyservice.FullPropertyName;
import com.arjuna.common.internal.util.propertyservice.PropertyPrefix;
import com.arjuna.common.util.propertyservice.PropertyManager;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.Enumeration;
import java.util.LinkedList;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class BeanPopulator {
    private static final ConcurrentMap<Class, Object> singletonBeanInstances = new ConcurrentHashMap<Class, Object>();

    public static <T> T getSingletonInstance(Class<T> beanClass, PropertyManager propertyManager) throws RuntimeException {
        if (!singletonBeanInstances.containsKey(beanClass)) {
            Object bean = null;
            try {
                bean = beanClass.newInstance();
                BeanPopulator.configureFromPropertyManager(bean, propertyManager);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            singletonBeanInstances.put(beanClass, bean);
        }
        return (T)singletonBeanInstances.get(beanClass);
    }

    public static void configureFromPropertyManager(Object bean, PropertyManager propertyManager) throws Exception {
        if (!bean.getClass().isAnnotationPresent(PropertyPrefix.class)) {
            throw new Exception("no PropertyPrefix found on " + bean.getClass().getName());
        }
        for (Field field : bean.getClass().getDeclaredFields()) {
            String getterMethodName;
            Class<?> type = field.getType();
            String setterMethodName = "set" + BeanPopulator.capitalizeFirstLetter(field.getName());
            Method setter = bean.getClass().getMethod(setterMethodName, field.getType());
            Method getter = null;
            if (field.getType().equals(Boolean.TYPE)) {
                getterMethodName = "is" + BeanPopulator.capitalizeFirstLetter(field.getName());
                try {
                    getter = bean.getClass().getMethod(getterMethodName, new Class[0]);
                }
                catch (NoSuchMethodException e) {
                    // empty catch block
                }
            }
            if (getter == null) {
                getterMethodName = "get" + BeanPopulator.capitalizeFirstLetter(field.getName());
                getter = bean.getClass().getMethod(getterMethodName, new Class[0]);
            }
            if (field.isAnnotationPresent(ConcatenationPrefix.class)) {
                BeanPopulator.handleGroupProperty(bean, propertyManager, field, setter, getter);
                continue;
            }
            BeanPopulator.handleSimpleProperty(bean, propertyManager, field, setter, getter);
        }
    }

    private static void handleGroupProperty(Object bean, PropertyManager propertyManager, Field field, Method setter, Method getter) throws Exception {
        Object valueFromBean;
        LinkedList<String> values = new LinkedList<String>();
        String valueFromPropertyManager = BeanPopulator.getValueFromPropertyManager(bean, propertyManager, field, bean.getClass().getSimpleName());
        if (valueFromPropertyManager != null) {
            String[] tokens;
            for (String token : tokens = valueFromPropertyManager.split("\\s+")) {
                values.add(token);
            }
        } else {
            LinkedList<String> listOfMatchingPropertyNames = new LinkedList<String>();
            Enumeration propertyNamesEnumeration = propertyManager.propertyNames();
            if (propertyNamesEnumeration != null) {
                String prefix = field.getAnnotation(ConcatenationPrefix.class).prefix();
                while (propertyNamesEnumeration.hasMoreElements()) {
                    String name = (String)propertyNamesEnumeration.nextElement();
                    if (!name.startsWith(prefix)) continue;
                    listOfMatchingPropertyNames.add(name);
                }
            }
            Collections.sort(listOfMatchingPropertyNames);
            for (String name : listOfMatchingPropertyNames) {
                String value = propertyManager.getProperty(name);
                values.add(value);
            }
        }
        if (!(valueFromBean = getter.invoke(bean, new Object[0])).equals(values)) {
            setter.invoke(bean, values);
        }
    }

    private static void handleSimpleProperty(Object bean, PropertyManager propertyManager, Field field, Method setter, Method getter) throws Exception {
        PropertyPrefix prefixAnnotation = bean.getClass().getAnnotation(PropertyPrefix.class);
        String prefix = prefixAnnotation.prefix();
        String valueFromPropertyManager = BeanPopulator.getValueFromPropertyManager(bean, propertyManager, field, prefix);
        if (valueFromPropertyManager != null) {
            Object valueFromBean = getter.invoke(bean, new Object[0]);
            if (field.getType().equals(Boolean.TYPE)) {
                if (!((Boolean)valueFromBean).booleanValue() && BeanPopulator.isPositive(valueFromPropertyManager)) {
                    setter.invoke(bean, Boolean.TRUE);
                }
                if (((Boolean)valueFromBean).booleanValue() && BeanPopulator.isNegative(valueFromPropertyManager)) {
                    setter.invoke(bean, Boolean.FALSE);
                }
            } else if (field.getType().equals(String.class)) {
                if (!valueFromPropertyManager.equals(valueFromBean)) {
                    setter.invoke(bean, valueFromPropertyManager);
                }
            } else if (field.getType().equals(Long.TYPE)) {
                Long longValue = Long.valueOf(valueFromPropertyManager);
                if (!longValue.equals(valueFromBean)) {
                    setter.invoke(bean, longValue);
                }
            } else if (field.getType().equals(Integer.TYPE)) {
                Integer intValue = Integer.valueOf(valueFromPropertyManager);
                if (!intValue.equals(valueFromBean)) {
                    setter.invoke(bean, intValue);
                }
            } else {
                throw new Exception("unknown field type " + field.getType());
            }
        }
    }

    private static String getValueFromPropertyManager(Object bean, PropertyManager propertyManager, Field field, String prefix) {
        String propertyFileKey;
        String valueFromPropertyManager = null;
        if (valueFromPropertyManager == null) {
            propertyFileKey = bean.getClass().getCanonicalName() + "." + field.getName();
            valueFromPropertyManager = propertyManager.getProperty(propertyFileKey);
        }
        if (valueFromPropertyManager == null) {
            propertyFileKey = bean.getClass().getSimpleName() + "." + field.getName();
            valueFromPropertyManager = propertyManager.getProperty(propertyFileKey);
        }
        if (valueFromPropertyManager == null) {
            propertyFileKey = prefix + field.getName();
            if (field.isAnnotationPresent(FullPropertyName.class)) {
                FullPropertyName fullPropertyName = field.getAnnotation(FullPropertyName.class);
                propertyFileKey = fullPropertyName.name();
            }
            valueFromPropertyManager = propertyManager.getProperty(propertyFileKey);
        }
        return valueFromPropertyManager;
    }

    private static String capitalizeFirstLetter(String string) {
        return string.length() > 0 ? Character.toUpperCase(string.charAt(0)) + string.substring(1) : string;
    }

    private static boolean isPositive(String value) {
        return "YES".equalsIgnoreCase(value) || "ON".equalsIgnoreCase(value) || "TRUE".equalsIgnoreCase(value);
    }

    private static boolean isNegative(String value) {
        return "NO".equalsIgnoreCase(value) || "OFF".equalsIgnoreCase(value) || "FALSE".equalsIgnoreCase(value);
    }
}

