/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.common.util.propertyservice;

import com.arjuna.common.internal.util.propertyservice.PropertyManagerImpl;
import com.arjuna.common.internal.util.propertyservice.plugins.io.XMLFilePlugin;
import com.arjuna.common.util.FileLocator;
import com.arjuna.common.util.propertyservice.PropertyManager;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;

public class PropertyManagerFactory {
    private static ConcurrentMap<String, PropertyManager> propertyManagersByModuleName = new ConcurrentHashMap<String, PropertyManager>();
    private static ConcurrentMap<String, PropertyManager> propertyManagersByCanonicalFileName = new ConcurrentHashMap<String, PropertyManager>();

    public static PropertyManager getPropertyManagerForModule(String moduleName, String fileNamePropertyKey) {
        if (propertyManagersByModuleName.containsKey(moduleName)) {
            return (PropertyManager)propertyManagersByModuleName.get(moduleName);
        }
        return PropertyManagerFactory.createPropertyManagerForModule(moduleName, fileNamePropertyKey);
    }

    public static PropertyManager getPropertyManagerForFile(String propertyFileName, boolean withCaching) {
        String filepath = null;
        try {
            filepath = FileLocator.locateFile(propertyFileName);
            File propertyFile = new File(filepath);
            if (!propertyFile.exists() || !propertyFile.isFile()) {
                throw new RuntimeException("invalid property file " + filepath);
            }
            filepath = propertyFile.getCanonicalPath();
        }
        catch (FileNotFoundException fileNotFoundException) {
            URL url = PropertyManagerFactory.class.getResource("/default-" + propertyFileName);
            if (url == null) {
                throw new RuntimeException("missing property file " + propertyFileName);
            }
            filepath = url.toString();
        }
        catch (IOException e) {
            throw new RuntimeException("invalid property file " + filepath, e);
        }
        PropertyManager propertyManager = null;
        if (withCaching) {
            propertyManager = (PropertyManager)propertyManagersByCanonicalFileName.get(filepath);
        }
        if (propertyManager == null) {
            propertyManager = new PropertyManagerImpl(propertyFileName);
            try {
                PropertyManager existingPropertyManager;
                propertyManager.load(XMLFilePlugin.class.getName(), filepath);
                if (withCaching && (existingPropertyManager = propertyManagersByCanonicalFileName.putIfAbsent(filepath, propertyManager)) != null) {
                    propertyManager = existingPropertyManager;
                }
            }
            catch (Exception e) {
                throw new RuntimeException("unable to load properties from file " + filepath, e);
            }
        }
        return propertyManager;
    }

    private static synchronized PropertyManager createPropertyManagerForModule(String moduleName, String fileNamePropertyKey) {
        if (propertyManagersByModuleName.containsKey(moduleName)) {
            return (PropertyManager)propertyManagersByModuleName.get(moduleName);
        }
        String propertyFileName = System.getProperty(fileNamePropertyKey);
        if (propertyFileName == null) {
            propertyFileName = PropertyManagerFactory.getFileNameFromBuildTimeProperties(moduleName);
        }
        if (propertyFileName == null) {
            throw new RuntimeException("Unable to resolve property file name for module " + moduleName);
        }
        PropertyManager propertyManager = PropertyManagerFactory.getPropertyManagerForFile(propertyFileName, true);
        propertyManagersByModuleName.put(moduleName, propertyManager);
        return propertyManager;
    }

    private static String getFileNameFromBuildTimeProperties(String moduleName) {
        Properties buildTimeProperties = new Properties();
        InputStream is = PropertyManagerFactory.class.getResourceAsStream("/" + moduleName + ".properties");
        if (is != null) {
            try {
                buildTimeProperties.load(is);
            }
            catch (IOException e) {
                try {
                    is.close();
                }
                catch (IOException e2) {
                    // empty catch block
                }
            }
        }
        return buildTimeProperties.getProperty("PROPERTIES_FILE");
    }
}

