/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.orbportability.event;

import com.arjuna.orbportability.common.opPropertyManager;
import com.arjuna.orbportability.event.EventHandler;
import com.arjuna.orbportability.logging.opLogger;
import java.util.Enumeration;
import java.util.Hashtable;
import org.omg.CORBA.Object;

public class EventManager {
    private Hashtable _handlers = new Hashtable();
    private static EventManager _theManager = null;

    public void connected(Object obj) {
        Enumeration e = this._handlers.elements();
        while (e.hasMoreElements()) {
            EventHandler h = (EventHandler)e.nextElement();
            try {
                h.connected(obj);
            }
            catch (Throwable ex) {
                if (!opLogger.loggerI18N.isWarnEnabled()) continue;
                opLogger.loggerI18N.warn("com.arjuna.orbportability.event.EventManager.forhandlethrewexception", new java.lang.Object[]{"com.arjuna.orbportability.event.EventManager.connected()", h.name(), ex});
            }
        }
    }

    public void disconnected(Object obj) {
        Enumeration e = this._handlers.elements();
        while (e.hasMoreElements()) {
            EventHandler h = (EventHandler)e.nextElement();
            try {
                h.disconnected(obj);
            }
            catch (Throwable ex) {
                if (!opLogger.loggerI18N.isWarnEnabled()) continue;
                opLogger.loggerI18N.warn("com.arjuna.orbportability.event.EventManager.forhandlethrewexception", new java.lang.Object[]{"com.arjuna.orbportability.event.EventManager.disconnected(Object)", h.name(), ex});
            }
        }
    }

    public boolean addHandler(EventHandler h) {
        if (this._handlers.get(h) == null) {
            this._handlers.put(h, h);
            return true;
        }
        return false;
    }

    public boolean removeHandler(EventHandler h) {
        return this._handlers.remove(h) != null;
    }

    public static synchronized EventManager getManager() {
        if (_theManager == null) {
            _theManager = new EventManager();
        }
        return _theManager;
    }

    protected EventManager() {
        for (String handlerName : opPropertyManager.getOrbPortabilityEnvironmentBean().getEventHandlers()) {
            try {
                Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(handlerName);
                EventHandler h = (EventHandler)c.newInstance();
                this.addHandler(h);
            }
            catch (Exception ex) {
                if (!opLogger.loggerI18N.isWarnEnabled()) continue;
                opLogger.loggerI18N.warn("com.arjuna.orbportability.event.EventManager.caughtexceptionfor", new java.lang.Object[]{"EventManager", ex, handlerName});
            }
        }
    }
}

