/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.ats.internal.jts.orbspecific.recovery.recoverycoordinators;

import com.arjuna.ats.arjuna.common.Uid;
import com.arjuna.ats.internal.jts.orbspecific.coordinator.ArjunaTransactionImple;
import com.arjuna.ats.internal.jts.orbspecific.interposition.coordinator.ServerTransaction;
import com.arjuna.ats.internal.jts.orbspecific.recovery.recoverycoordinators.RecoveryCoordinatorId;
import com.arjuna.ats.internal.jts.recovery.contact.StatusChecker;
import com.arjuna.ats.internal.jts.recovery.recoverycoordinators.ResourceCompletor;
import com.arjuna.ats.internal.jts.recovery.transactions.RecoveredTransactionReplayer;
import com.arjuna.ats.internal.jts.recovery.transactions.RecoveryStatus;
import com.arjuna.ats.jts.common.jtsPropertyManager;
import com.arjuna.ats.jts.logging.jtsLogger;
import org.omg.CORBA.SystemException;
import org.omg.CosTransactions.Inactive;
import org.omg.CosTransactions.NotPrepared;
import org.omg.CosTransactions.RecoveryCoordinatorPOA;
import org.omg.CosTransactions.Resource;
import org.omg.CosTransactions.Status;

public class GenericRecoveryCoordinator
extends RecoveryCoordinatorPOA {
    private RecoveryCoordinatorId _id;
    private static boolean _issueRecoveryRollback = jtsPropertyManager.getJTSEnvironmentBean().isIssueRecoveryRollback();

    public GenericRecoveryCoordinator(Uid RCUid, Uid actionUid, Uid processUid, boolean isServerTransaction) {
        this._id = new RecoveryCoordinatorId(RCUid, actionUid, processUid, isServerTransaction);
        if (jtsLogger.loggerI18N.isDebugEnabled()) {
            jtsLogger.loggerI18N.debug(1L, 4L, 2048L, "com.arjuna.ats.internal.jts.recovery.recoverycoordinators.GenericRecoveryCoordinator_1", new Object[]{this._id});
        }
    }

    protected GenericRecoveryCoordinator() {
        if (jtsLogger.loggerI18N.isDebugEnabled()) {
            jtsLogger.loggerI18N.debug(1L, 4L, 2048L, "com.arjuna.ats.internal.jts.recovery.recoverycoordinators.GenericRecoveryCoordinator_2");
        }
        this._id = null;
    }

    @Override
    public Status replay_completion(Resource res) throws SystemException, NotPrepared {
        return GenericRecoveryCoordinator.replay_completion(this._id, res);
    }

    protected static Status replay_completion(RecoveryCoordinatorId id, Resource res) throws SystemException, NotPrepared {
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(16L, 4L, 2048L, "GenericRecoveryCoordinator(" + id._RCUid + ").replay_completion(" + (res != null ? "resource supplied)" : "null resource)"));
        }
        Status currentStatus = Status.StatusUnknown;
        boolean transactionActive = true;
        try {
            currentStatus = GenericRecoveryCoordinator.get_status(id._actionUid, id._originalProcessUid);
        }
        catch (Inactive e) {
            transactionActive = false;
        }
        if (currentStatus == Status.StatusNoTransaction) {
            currentStatus = Status.StatusRolledBack;
        } else if (currentStatus == Status.StatusCommitted) {
            currentStatus = Status.StatusCommitting;
        }
        if (!transactionActive) {
            String tranType = id._isServerTransaction ? ServerTransaction.typeName() : ArjunaTransactionImple.typeName();
            RecoveredTransactionReplayer replayer = new RecoveredTransactionReplayer(id._actionUid, tranType);
            currentStatus = replayer.getStatus();
            if (replayer.getRecoveryStatus() != RecoveryStatus.ACTIVATE_FAILED && res != null) {
                if (jtsLogger.loggerI18N.isDebugEnabled()) {
                    jtsLogger.loggerI18N.debug(16L, 4L, 2048L, "com.arjuna.ats.internal.jts.recovery.recoverycoordinators.GenericRecoveryCoordinator_4", new Object[]{id._RCUid});
                }
                replayer.swapResource(id._RCUid, res);
            }
            if (replayer.getRecoveryStatus() != RecoveryStatus.ACTIVATE_FAILED) {
                replayer.replayPhase2();
            } else {
                replayer.tidyup();
                currentStatus = Status.StatusRolledBack;
            }
        }
        if (currentStatus == Status.StatusRolledBack && _issueRecoveryRollback) {
            ResourceCompletor resourceCompletor = new ResourceCompletor(res, 0);
            resourceCompletor.start();
        }
        if (currentStatus == Status.StatusActive) {
            throw new NotPrepared();
        }
        return currentStatus;
    }

    public static String makeId(Uid rcUid, Uid tranUid, Uid processUid, boolean isServerTransaction) {
        RecoveryCoordinatorId id = new RecoveryCoordinatorId(rcUid, tranUid, processUid, isServerTransaction);
        return id.makeId();
    }

    public static GenericRecoveryCoordinator reconstruct(String encodedRCData) {
        RecoveryCoordinatorId id;
        if (jtsLogger.logger.isDebugEnabled()) {
            jtsLogger.logger.debug(1L, 4L, 2048L, "GenericRecoveryCoordinator.reconstruct(" + encodedRCData + ")");
        }
        if ((id = RecoveryCoordinatorId.reconstruct(encodedRCData)) != null) {
            return new GenericRecoveryCoordinator(id);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Status get_status(Uid actionUid, Uid processUid) throws Inactive {
        Status status;
        block10: {
            status = Status.StatusUnknown;
            boolean transactionActive = true;
            try {
                status = StatusChecker.get_current_status(actionUid, processUid);
            }
            catch (Inactive e) {
                transactionActive = false;
            }
            boolean hasBeenRecovering = false;
            while (transactionActive) {
                Object o = RecoveredTransactionReplayer.isPresent(actionUid);
                if (o != null) {
                    hasBeenRecovering = true;
                    Object object = o;
                    synchronized (object) {
                        try {
                            o.wait();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                        continue;
                    }
                }
                if (hasBeenRecovering) {
                    throw new Inactive();
                }
                break block10;
            }
            throw new Inactive();
        }
        return status;
    }

    private GenericRecoveryCoordinator(RecoveryCoordinatorId id) {
        this._id = id;
    }
}

