/*
 * Decompiled with CFR 0.152.
 */
package com.arjuna.orbportability.oa.core;

import com.arjuna.orbportability.common.opPropertyManager;
import com.arjuna.orbportability.logging.opLogger;
import com.arjuna.orbportability.oa.core.POAImple;
import com.arjuna.orbportability.orb.core.ORB;
import org.omg.CORBA.ORBPackage.InvalidName;
import org.omg.CORBA.Policy;
import org.omg.CORBA.SystemException;
import org.omg.PortableServer.POA;
import org.omg.PortableServer.POAManagerPackage.AdapterInactive;
import org.omg.PortableServer.POAPackage.AdapterAlreadyExists;
import org.omg.PortableServer.POAPackage.InvalidPolicy;

public class OA {
    private ORB _theORB;
    private POAImple _theOA;

    public OA(ORB theORB) {
        this.initialise();
        this._theORB = theORB;
    }

    public boolean initialised() {
        return this._theOA.initialised();
    }

    public void init() throws InvalidName, AdapterInactive, SystemException {
        this._theOA.init(this._theORB);
    }

    public void createPOA(String adapterName, Policy[] policies) throws AdapterAlreadyExists, InvalidPolicy, AdapterInactive, SystemException {
        this._theOA.createPOA(adapterName, policies);
    }

    public void destroyRootPOA() throws SystemException {
        this._theOA.destroyRootPOA();
    }

    public void destroyPOA(String adapterName) throws SystemException {
        this._theOA.destroyPOA(adapterName);
    }

    public POA rootPoa() throws SystemException {
        return this._theOA.rootPoa();
    }

    public void rootPoa(POA thePOA) throws SystemException {
        this._theOA.rootPoa(thePOA);
    }

    public POA poa(String adapterName) throws SystemException {
        return this._theOA.poa(adapterName);
    }

    public void poa(String adapterName, POA thePOA) throws SystemException {
        this._theOA.poa(adapterName, thePOA);
    }

    public void run(String name) throws SystemException {
        this._theOA.run(this._theORB, name);
    }

    public void run() throws SystemException {
        this._theOA.run(this._theORB);
    }

    private final void initialise() {
        String className = opPropertyManager.getOrbPortabilityEnvironmentBean().getOaImplementation();
        if (className == null) {
            try {
                Thread.currentThread().getContextClassLoader().loadClass("org.jacorb.orb.ORB");
                className = "com.arjuna.orbportability.internal.orbspecific.jacorb.oa.implementations.jacorb_2_0";
            }
            catch (ClassNotFoundException ce) {
                try {
                    Thread.currentThread().getContextClassLoader().loadClass("com.sun.corba.se.internal.corba.ORB");
                    className = "com.arjuna.orbportability.internal.orbspecific.javaidl.oa.implementations.javaidl_1_4";
                }
                catch (ClassNotFoundException je) {
                    if (opLogger.loggerI18N.isFatalEnabled()) {
                        opLogger.loggerI18N.fatal("com.arjuna.orbportability.oa.core.OA.nosupportedorb", je);
                    }
                    throw new ExceptionInInitializerError(opLogger.logMesg.getString("com.arjuna.orbportability.oa.core.OA.nosupportedorb"));
                }
            }
        }
        if (opLogger.logger.isDebugEnabled()) {
            opLogger.logger.debug(16L, 4L, 1L, "OA.initialise() - using OA Implementation " + className);
        }
        try {
            Class<?> c = Thread.currentThread().getContextClassLoader().loadClass(className);
            this._theOA = (POAImple)c.newInstance();
        }
        catch (Exception e) {
            if (opLogger.loggerI18N.isFatalEnabled()) {
                opLogger.loggerI18N.fatal("com.arjuna.orbportability.oa.core.OA.caughtexception", new Object[]{e}, e);
            }
            throw new ExceptionInInitializerError(opLogger.logMesg.getString("com.arjuna.orbportability.oa.core.OA.caughtexception"));
        }
    }
}

