/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.licenses;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import me.snowdrop.licenses.LicensesGeneratorException;
import me.snowdrop.licenses.xml.DependencyElement;
import me.snowdrop.licenses.xml.LicenseElement;
import me.snowdrop.licenses.xml.LicenseSummary;
import org.apache.commons.io.FileUtils;
import org.jtwig.JtwigModel;
import org.jtwig.JtwigTemplate;

public class LicensesFileManager {
    private final Logger logger = Logger.getLogger(LicensesFileManager.class.getSimpleName());

    public void createLicensesXml(LicenseSummary licenseSummary, String directoryPath) throws LicensesGeneratorException {
        File file = new File(directoryPath, "licenses.xml");
        try {
            FileUtils.writeStringToFile((File)file, (String)licenseSummary.toXmlString());
        }
        catch (IOException | JAXBException e) {
            throw new LicensesGeneratorException("Failed to create licenses.xml", e);
        }
    }

    public void createLicensesHtml(LicenseSummary licenseSummary, String directoryPath) throws LicensesGeneratorException {
        Map<String, String> licenseFiles = this.downloadLicenseFiles(licenseSummary.getDependencies(), directoryPath);
        File file = new File(directoryPath, "licenses.html");
        JtwigTemplate template = JtwigTemplate.classpathTemplate((String)"licenses.twig");
        JtwigModel model = JtwigModel.newModel().with("dependencies", licenseSummary.getDependencies()).with("licenseFiles", licenseFiles);
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            template.render(model, (OutputStream)fileOutputStream);
        }
        catch (IOException e) {
            throw new LicensesGeneratorException("Failed to create licenses.html", e);
        }
    }

    private Map<String, String> downloadLicenseFiles(List<DependencyElement> dependencies, String directoryPath) {
        return dependencies.stream().map(DependencyElement::getLicenses).flatMap(Collection::stream).map(l -> this.downloadLicenseFile((LicenseElement)l, directoryPath)).filter(Optional::isPresent).map(Optional::get).distinct().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    private Optional<Map.Entry<String, String>> downloadLicenseFile(LicenseElement license, String directoryPath) {
        try {
            String fileName = this.getLocalLicenseFileName(license);
            File file = new File(directoryPath, fileName);
            if (!file.exists()) {
                URL url = new URL(license.getTextUrl());
                FileUtils.copyURLToFile((URL)url, (File)file);
            }
            return Optional.of(new AbstractMap.SimpleEntry<String, String>(license.getName(), fileName));
        }
        catch (IOException e) {
            this.logger.warning(String.format("Failed to download license '%s' from '%s': %s", license.getName(), license.getTextUrl(), e.getMessage()));
            return Optional.empty();
        }
    }

    private String getLocalLicenseFileName(LicenseElement licenseElement) {
        String fileName = licenseElement.getName().replaceAll("[^A-Za-z0-9 ]", "");
        return "content/" + fileName.replace(" ", "+");
    }
}

