/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.licenses;

import java.nio.file.Path;
import java.util.Collection;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import me.snowdrop.licenses.maven.MavenProjectFactory;
import me.snowdrop.licenses.utils.Gav;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.project.MavenProject;

public class GavFinder {
    private final MavenProjectFactory mavenProjectFactory;

    GavFinder(MavenProjectFactory mavenProjectFactory) {
        this.mavenProjectFactory = mavenProjectFactory;
    }

    public Collection<Gav> inMavenProject(Path pomPath) {
        return this.getArtifactsForMavenProject(pomPath).map(a -> new Gav(a.getGroupId(), a.getArtifactId(), a.getVersion(), a.getType())).collect(Collectors.toSet());
    }

    Stream<Artifact> getArtifactsForMavenProject(Path pomPath) {
        return this.mavenProjectFactory.getMavenProjects(pomPath.toFile(), true).stream().map(MavenProject::getArtifacts).flatMap(Collection::stream);
    }
}

