/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.licenses;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.xml.bind.JAXBException;
import me.snowdrop.licenses.LicensesGeneratorException;
import me.snowdrop.licenses.xml.DependencyElement;
import me.snowdrop.licenses.xml.LicenseElement;
import me.snowdrop.licenses.xml.LicenseSummary;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.jtwig.JtwigModel;
import org.jtwig.JtwigTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LicensesFileManager {
    private static final int DOWNLOAD_TIMEOUT = 60000;
    private static final String CONTENTS_DIR = "contents";
    private final Logger logger = LoggerFactory.getLogger(LicensesFileManager.class);
    private final CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultRequestConfig(RequestConfig.custom().setConnectTimeout(60000).setSocketTimeout(60000).build()).build();

    public void createLicensesXml(LicenseSummary licenseSummary, String directoryPath) throws LicensesGeneratorException {
        this.logger.debug("Generating licenses.xml at {}", (Object)directoryPath);
        File file = new File(directoryPath, "licenses.xml");
        try {
            FileUtils.writeStringToFile((File)file, (String)licenseSummary.toXmlString(), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException | JAXBException e) {
            throw new LicensesGeneratorException("Failed to create licenses.xml", e);
        }
    }

    public void createLicensesHtml(LicenseSummary licenseSummary, String directoryPath) throws LicensesGeneratorException {
        this.logger.debug("Generating licenses.html at {}", (Object)directoryPath);
        Map<String, String> licenseFiles = this.downloadLicenseFiles(licenseSummary.getDependencies(), directoryPath);
        File file = new File(directoryPath, "licenses.html");
        JtwigTemplate template = JtwigTemplate.classpathTemplate((String)"licenses.twig");
        JtwigModel model = JtwigModel.newModel().with("dependencies", licenseSummary.getDependencies()).with("licenseFiles", licenseFiles);
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            template.render(model, (OutputStream)fileOutputStream);
        }
        catch (IOException e) {
            throw new LicensesGeneratorException("Failed to create licenses.html", e);
        }
    }

    private Map<String, String> downloadLicenseFiles(List<DependencyElement> dependencies, String directoryPath) {
        File licenseContentsDirectory = new File(directoryPath, CONTENTS_DIR);
        licenseContentsDirectory.mkdirs();
        return dependencies.stream().flatMap(dependency -> dependency.getLicenses().stream().map(license -> this.downloadLicenseFile((DependencyElement)dependency, (LicenseElement)license, licenseContentsDirectory))).filter(Optional::isPresent).map(Optional::get).distinct().collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Optional<Map.Entry<String, String>> downloadLicenseFile(DependencyElement dependency, LicenseElement license, File licenseContentsDirectory) {
        String textUrl = license.getTextUrl();
        if (StringUtils.isBlank((CharSequence)textUrl)) {
            return Optional.empty();
        }
        this.logger.debug("Downloading license file for {} from {}", (Object)dependency.toGavString(), (Object)textUrl);
        try {
            String fileName = this.getLocalLicenseFileName(license);
            File file = new File(licenseContentsDirectory, fileName);
            boolean download = false;
            if (!file.exists()) {
                LicensesFileManager licensesFileManager = this;
                synchronized (licensesFileManager) {
                    if (!file.exists()) {
                        file.createNewFile();
                        download = true;
                    }
                }
            }
            if (download) {
                try {
                    this.downloadTo(textUrl, file);
                }
                catch (IOException e) {
                    if (!textUrl.startsWith("https")) {
                        this.downloadTo(textUrl.replace("http", "https"), file);
                    }
                    throw e;
                }
            }
            return Optional.of(new AbstractMap.SimpleEntry<String, String>(license.getName(), String.format("%s/%s", CONTENTS_DIR, fileName)));
        }
        catch (Exception e) {
            this.logger.warn("Failed to download license '{}' for '{}' from '{}'", new Object[]{license.getName(), dependency.toGavString(), textUrl, e});
            return Optional.empty();
        }
    }

    private void downloadTo(String url, File file) throws IOException {
        HttpGet request = new HttpGet(url);
        CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)request);
        HttpEntity entity = response.getEntity();
        if (entity != null) {
            try (FileOutputStream stream = new FileOutputStream(file);){
                entity.writeTo((OutputStream)stream);
            }
        }
    }

    private String getLocalLicenseFileName(LicenseElement licenseElement) {
        String fileName = licenseElement.getName().replaceAll("[^A-Za-z0-9 ]", "");
        return fileName.replace(" ", "+");
    }
}

