/*
 * Decompiled with CFR 0.152.
 */
package me.snowdrop.licenses.sanitiser.exceptions;

import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.json.JsonObject;
import me.snowdrop.licenses.sanitiser.exceptions.ExactVersionMatcher;
import me.snowdrop.licenses.sanitiser.exceptions.RangeVersionMatcher;
import me.snowdrop.licenses.sanitiser.exceptions.RegexpVersionMatcher;
import me.snowdrop.licenses.sanitiser.exceptions.VersionMatcher;
import me.snowdrop.licenses.xml.DependencyElement;
import me.snowdrop.licenses.xml.LicenseElement;

public class LicenseException {
    private String groupId;
    private String artifactId;
    private VersionMatcher versionMatcher;
    private Set<LicenseElement> licenses;

    public LicenseException(JsonObject jsonObject) {
        this.groupId = jsonObject.getString("groupId");
        Objects.requireNonNull(this.groupId, "groupId cannot be null");
        this.artifactId = jsonObject.getString("artifactId");
        Objects.requireNonNull(this.artifactId, "artifactId cannot be null");
        if (jsonObject.containsKey((Object)"version")) {
            this.versionMatcher = new ExactVersionMatcher(jsonObject.getString("version"));
        } else if (jsonObject.containsKey((Object)"version-range")) {
            this.versionMatcher = new RangeVersionMatcher(jsonObject.getString("version-range"));
        } else if (jsonObject.containsKey((Object)"version-regexp")) {
            this.versionMatcher = new RegexpVersionMatcher(jsonObject.getString("version-regexp"));
        } else {
            throw new IllegalArgumentException("License exception for " + this.groupId + ":" + this.artifactId + " must contain 'version' or 'version-range' or 'version-regexp'");
        }
        this.licenses = jsonObject.getJsonArray("licenses").getValuesAs(JsonObject.class).stream().map(LicenseElement::new).collect(Collectors.toSet());
    }

    public boolean matches(DependencyElement dependency) {
        return this.groupId.equals(dependency.getGroupId()) && this.artifactId.equals(dependency.getArtifactId()) && this.versionMatcher.matches(dependency.getVersion());
    }

    public Set<LicenseElement> getLicenses() {
        return this.licenses;
    }
}

