/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.extensions.text.highlight.scanner;

import org.aesh.extensions.highlight.Syntax;
import org.aesh.extensions.highlight.TokenType;
import org.aesh.extensions.highlight.scanner.CSSScanner;
import org.aesh.extensions.text.highlight.encoder.AssertEncoder;
import org.aesh.extensions.text.highlight.scanner.AbstractScannerTestCase;
import org.junit.Ignore;
import org.junit.Test;

public class CSSScannerTestCase
extends AbstractScannerTestCase {
    @Test
    @Ignore
    public void should() throws Exception {
        String source = "/* See http://reference.sitepoint.com/css/content. */\n@media print {\n  a[href]:after {\n    content: \"<\" attr(href) \">\";\n  }\n}\n\na:link:after, a:visited:after {content:\" (\" attr(href) \")\";font-size:90%;}\nol {\n  counter-reset: item;\n  margin: 0;\n  padding: 0.7px;\n}\n.some {}ol>li {\n  counter-increment: item;\n  list-style: none inside;\n}\nol>li:before {\n  content: counters(item, \".\") \" - \";\n}\n\nbody {\n  counter-reset: chapter;\n}\nh1 {\n  counter-increment: chapter;\n  counter-reset: section;\n}\nh2 {\n  counter-increment: section;\n}\nh2:before {\n  content: counter(chapter) \".\" counter(section) \" \";\n}\n";
        Syntax.Builder.create().scannerType(CSSScanner.TYPE.getName()).encoderType("TEST").execute(source);
        AssertEncoder.assertTextToken(TokenType.attribute_name, "href");
        AssertEncoder.assertTextToken(TokenType.directive, "@media");
        AssertEncoder.assertTextToken(TokenType.comment, "/* See http://reference.sitepoint.com/css/content. */");
        AssertEncoder.assertTextToken(TokenType.tag, "a", "body", "ol");
        AssertEncoder.assertTextToken(TokenType.class_, ".some");
        AssertEncoder.assertTextToken(TokenType.float_, "0", "0.7px");
        AssertEncoder.assertTextToken(TokenType.key, "list-style", "counter-increment", "margin");
        AssertEncoder.assertTextToken(TokenType.operator, ";", "{", "}", ",");
    }

    @Test
    public void shouldMatchCssStandardExample() throws Exception {
        this.assertMatchExample(Syntax.Builder.create(), "css", "standard.in.css");
    }

    @Test
    @Ignore
    public void shouldMatchCssYUIExample() throws Exception {
        this.assertMatchExample(Syntax.Builder.create(), "css", "yui.in.css");
    }

    @Test
    public void shouldMatchCssDemoExample() throws Exception {
        this.assertMatchExample(Syntax.Builder.create(), "css", "demo.in.css");
    }

    @Test
    public void shouldMatchCssCoderayExample() throws Exception {
        this.assertMatchExample(Syntax.Builder.create(), "css", "coderay.in.css");
    }

    @Test
    public void shouldMatchCssRadmineExample() throws Exception {
        this.assertMatchExample(Syntax.Builder.create(), "css", "redmine.in.css");
    }

    @Test
    @Ignore
    public void shouldMatchCssIgnosDraconisExample() throws Exception {
        this.assertMatchExample(Syntax.Builder.create(), "css", "ignos-draconis.in.css");
    }

    @Test
    @Ignore
    public void shouldMatchCssS5Example() throws Exception {
        this.assertMatchExample(Syntax.Builder.create(), "css", "S5.in.css");
    }
}

