/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.extensions.tty;

import java.nio.charset.Charset;
import java.util.Arrays;
import java.util.function.Consumer;
import org.aesh.readline.terminal.Key;
import org.aesh.terminal.Attributes;
import org.aesh.terminal.BaseDevice;
import org.aesh.terminal.Connection;
import org.aesh.terminal.Device;
import org.aesh.terminal.tty.Capability;
import org.aesh.terminal.tty.Signal;
import org.aesh.terminal.tty.Size;
import org.aesh.util.Parser;
import org.junit.Assert;

public class TestConnection
implements Connection {
    private Consumer<Size> sizeHandler;
    private Consumer<Signal> signalHandler;
    private Consumer<int[]> stdinHandler;
    private Consumer<int[]> stdOutHandler;
    private Consumer<Void> closeHandler;
    private StringBuilder bufferBuilder = new StringBuilder();
    private String out;
    private Size size;
    private Attributes attributes;
    private volatile boolean reading = false;

    public TestConnection() {
        this(new Size(80, 20), true);
    }

    public TestConnection(boolean stripAnsiCodes) {
        this(new Size(80, 20), stripAnsiCodes);
    }

    public TestConnection(Size size) {
        this(size, true);
    }

    public TestConnection(Size size, boolean stripAnsiCodes) {
        this.stdOutHandler = ints -> {
            if (stripAnsiCodes) {
                this.bufferBuilder.append(Parser.stripAwayAnsiCodes((String)Parser.fromCodePoints((int[])ints)));
            } else {
                this.bufferBuilder.append(Parser.fromCodePoints((int[])ints));
            }
        };
        this.size = size == null ? new Size(80, 20) : size;
        this.attributes = new Attributes();
    }

    public void clearOutputBuffer() {
        if (this.bufferBuilder.length() > 0) {
            this.bufferBuilder.delete(0, this.bufferBuilder.length());
        }
    }

    public String getOutputBuffer() {
        return this.bufferBuilder.toString();
    }

    public String getLine() {
        return this.out;
    }

    public Device device() {
        return new BaseDevice(){

            public String type() {
                return "vt100";
            }

            public boolean getBooleanCapability(Capability capability) {
                return false;
            }

            public Integer getNumericCapability(Capability capability) {
                return null;
            }

            public String getStringCapability(Capability capability) {
                return null;
            }
        };
    }

    public Size size() {
        return this.size;
    }

    public Consumer<Size> getSizeHandler() {
        return this.sizeHandler;
    }

    public void setSizeHandler(Consumer<Size> handler) {
        this.sizeHandler = handler;
    }

    public Consumer<Signal> getSignalHandler() {
        return this.signalHandler;
    }

    public void setSignalHandler(Consumer<Signal> handler) {
        this.signalHandler = handler;
    }

    public Consumer<int[]> getStdinHandler() {
        return this.stdinHandler;
    }

    public void setStdinHandler(Consumer<int[]> handler) {
        this.stdinHandler = handler;
    }

    public Consumer<int[]> stdoutHandler() {
        return this.stdOutHandler;
    }

    public void setCloseHandler(Consumer<Void> closeHandler) {
        this.closeHandler = closeHandler;
    }

    public Consumer<Void> getCloseHandler() {
        return this.closeHandler;
    }

    public void close() {
        this.reading = false;
        this.closeHandler.accept(null);
    }

    public void openBlocking() {
        this.reading = true;
    }

    public void openNonBlocking() {
    }

    private void doRead(int[] input) {
        if (this.reading) {
            if (this.stdinHandler != null) {
                this.stdinHandler.accept(input);
            } else {
                try {
                    Thread.sleep(10L);
                    this.doRead(input);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        } else {
            throw new RuntimeException("Got input when not reading: " + Arrays.toString(input));
        }
    }

    public boolean put(Capability capability, Object ... params) {
        return false;
    }

    public Attributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Attributes attributes) {
        this.attributes = attributes;
    }

    public Charset inputEncoding() {
        return Charset.defaultCharset();
    }

    public Charset outputEncoding() {
        return Charset.defaultCharset();
    }

    public void assertLine(String expected) {
        Assert.assertEquals((Object)expected, (Object)this.out);
    }

    public void assertBuffer(String expected) {
        Assert.assertEquals((Object)expected, (Object)this.bufferBuilder.toString());
    }

    public void assertBufferEndsWith(String expected) {
        Assert.assertTrue((boolean)this.bufferBuilder.toString().endsWith(expected));
    }

    public void read(int ... data) {
        this.doRead(data);
    }

    public void read(Key key) {
        this.doRead(key.getKeyValues());
    }

    public void read(String data) {
        this.doRead(Parser.toCodePoints((String)data));
    }

    public boolean supportsAnsi() {
        return false;
    }
}

