/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.extensions.common;

import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import org.aesh.command.Command;
import org.aesh.command.impl.registry.AeshCommandRegistryBuilder;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.command.registry.CommandRegistry;
import org.aesh.command.settings.Settings;
import org.aesh.command.settings.SettingsBuilder;
import org.aesh.extensions.tty.TestConnection;
import org.aesh.readline.AeshContext;
import org.aesh.readline.ReadlineConsole;
import org.aesh.terminal.Connection;
import org.aesh.utils.Config;

public class AeshTestCommons {
    private ReadlineConsole console;
    private CommandRegistry registry;
    private TestConnection connection;
    private FileAttribute fileAttribute = PosixFilePermissions.asFileAttribute(PosixFilePermissions.fromString("rwxrwxrwx"));

    protected String getStream() {
        return this.connection.getOutputBuffer();
    }

    protected TestConnection connection() {
        return this.connection;
    }

    protected void prepare(Class<? extends Command> ... commands) throws IOException, CommandLineParserException {
        this.connection = new TestConnection(false);
        this.registry = new AeshCommandRegistryBuilder().commands((Class[])commands).create();
        Settings settings = SettingsBuilder.builder().connection((Connection)this.connection).commandRegistry(this.registry).build();
        this.console = new ReadlineConsole(settings);
        this.console.start();
    }

    protected void finish() {
        this.smallPause();
        System.out.println("Got out: " + this.connection.getOutputBuffer());
        this.console.stop();
    }

    protected void smallPause() {
        try {
            Thread.sleep(150L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected void pushToOutput(String literalCommand) throws IOException {
        this.connection.read(literalCommand);
        this.connection.read(Config.getLineSeparator());
        this.smallPause();
    }

    protected void output(String literalCommand) throws IOException {
        this.connection.write(literalCommand);
        this.smallPause();
    }

    protected AeshContext getAeshContext() {
        return this.console.context();
    }

    protected Path createTempDirectory() throws IOException {
        Path tmp = Config.isOSPOSIXCompatible() ? Files.createTempDirectory("temp", this.fileAttribute) : Files.createTempDirectory("temp", new FileAttribute[0]);
        return tmp;
    }

    protected void deleteRecursiveTempDirectory(Path directory) throws IOException {
        Files.walkFileTree(directory, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

            @Override
            public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                Files.delete(file);
                return FileVisitResult.CONTINUE;
            }

            @Override
            public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
                Files.delete(dir);
                return FileVisitResult.CONTINUE;
            }
        });
    }
}

