/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.extensions.text.highlight;

import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.aesh.extensions.highlight.StringScanner;
import org.junit.Assert;
import org.junit.Ignore;
import org.junit.Test;

public class StringScannerTestCase {
    @Test
    public void shouldTrackIndex() throws Exception {
        String test = "abcde";
        StringScanner scan = new StringScanner(test);
        Assert.assertTrue((boolean)scan.hasMore());
        Assert.assertEquals((Object)"ab", (Object)scan.peek(2));
        Assert.assertEquals((Object)"a", (Object)scan.next());
        Assert.assertEquals((Object)"b", (Object)scan.next());
        Assert.assertTrue((scan.check("c") != null ? 1 : 0) != 0);
        Assert.assertTrue((scan.check("c") != null ? 1 : 0) != 0);
        Assert.assertEquals((Object)"cd", (Object)scan.scan("cd").group());
        Assert.assertEquals((Object)"e", (Object)scan.next());
        Assert.assertFalse((boolean)scan.hasMore());
    }

    @Test
    public void shouldScanUntil() throws Exception {
        String test = "aaaabc";
        StringScanner scan = new StringScanner(test);
        Assert.assertTrue((boolean)scan.hasMore());
        Assert.assertEquals((Object)"aaaab", (Object)scan.scanUntil("b").group());
        Assert.assertTrue((boolean)scan.hasMore());
        Assert.assertEquals((Object)"c", (Object)scan.next());
        Assert.assertFalse((boolean)scan.hasMore());
    }

    @Test
    @Ignore
    public void should2() throws Exception {
        String test = "package pl.silvermedia.ws";
        StringScanner scan = new StringScanner(test);
        Pattern p = Pattern.compile("[a-zA-Z_][A-Za-z_0-9]*|\\[\\]");
        System.out.println(scan.scan(p).group());
    }

    @Test
    public void shouldMatchMatcherGroups() throws Exception {
        Pattern p = Pattern.compile("<(?:(script|style)|[-\\w.:]+)(>)?", 32);
        String source = "<textarea disabled>\n  This text area has been disabled.\n</textarea>";
        Matcher m = p.matcher(source);
        m.find();
        StringScanner scanner = new StringScanner(source);
        MatchResult result = scanner.scan(p);
        Assert.assertEquals(null, (Object)m.group(1));
        Assert.assertEquals(null, (Object)m.group(2));
        Assert.assertEquals((Object)m.group(), (Object)result.group());
        Assert.assertEquals((Object)m.group(1), (Object)result.group(1));
        Assert.assertEquals((Object)m.group(2), (Object)result.group(2));
        Assert.assertEquals((long)-1L, (long)m.start(1));
        Assert.assertEquals((long)-1L, (long)m.start(2));
        Assert.assertEquals((long)m.start(), (long)result.start());
        Assert.assertEquals((long)m.start(1), (long)result.start(1));
        Assert.assertEquals((long)m.start(2), (long)result.start(2));
        Assert.assertEquals((long)-1L, (long)m.end(1));
        Assert.assertEquals((long)-1L, (long)m.end(2));
        Assert.assertEquals((long)m.end(), (long)result.end());
        Assert.assertEquals((long)m.end(1), (long)result.end(1));
        Assert.assertEquals((long)m.end(2), (long)result.end(2));
    }

    @Test
    public void shouldPeekPreviousWithNegativeNumber() throws Exception {
        String source = "abcd";
        StringScanner scanner = new StringScanner(source);
        scanner.next();
        scanner.next();
        Assert.assertEquals((Object)"b", (Object)scanner.peek(-1));
    }

    @Test
    public void shouldGetColumnIndex() throws Exception {
        String source = "abcd\nabcd";
        StringScanner scanner = new StringScanner(source);
        Assert.assertEquals((long)3L, (long)scanner.column(7));
    }
}

