/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.extensions.mv;

import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import org.aesh.command.parser.CommandLineParserException;
import org.aesh.extensions.cat.Cat;
import org.aesh.extensions.cd.Cd;
import org.aesh.extensions.common.AeshTestCommons;
import org.aesh.extensions.echo.Echo;
import org.aesh.extensions.mkdir.Mkdir;
import org.aesh.extensions.mv.Mv;
import org.aesh.extensions.touch.Touch;
import org.aesh.utils.Config;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MvTest
extends AeshTestCommons {
    private Path tempDir;

    @Before
    public void before() throws IOException {
        this.tempDir = this.createTempDirectory();
    }

    @After
    public void after() throws IOException {
        this.deleteRecursiveTempDirectory(this.tempDir);
    }

    @Test
    public void testMv() throws IOException, InterruptedException, CommandLineParserException {
        this.prepare(Touch.class, Mkdir.class, Echo.class, Cd.class, Cat.class, Mv.class);
        String temp = this.tempDir.toFile().getAbsolutePath() + Config.getPathSeparator();
        this.pushToOutput("touch " + temp + "file01.txt");
        Assert.assertTrue((boolean)new File(temp + "file01.txt").exists());
        this.pushToOutput("mv -v " + temp + "file01.txt " + temp + "file02.txt");
        Assert.assertTrue((boolean)new File(temp + "file02.txt").exists());
        this.pushToOutput("cd " + temp);
        this.pushToOutput("mkdir " + temp + "aesh_rocks");
        Assert.assertTrue((boolean)new File(temp + "aesh_rocks").exists());
        this.pushToOutput("mv -v " + temp + "aesh_rocks " + temp + "aesh");
        Assert.assertTrue((boolean)new File(temp + "aesh").exists());
        this.pushToOutput("touch " + temp + "file01.txt");
        Assert.assertTrue((boolean)new File(temp + "file01.txt").exists());
        this.pushToOutput("echo abc > " + temp + "file01.txt");
        this.pushToOutput("cat " + temp + "file01.txt");
        Assert.assertTrue((boolean)this.getStream().toString().contains("abc"));
        this.pushToOutput("mv -n " + temp + "file02.txt " + temp + "file01.txt");
        this.pushToOutput("cat " + temp + "file01.txt");
        Assert.assertTrue((boolean)this.getStream().toString().contains("abc"));
        this.finish();
    }
}

