/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.impl;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.aesh.terminal.impl.AbstractPosixTerminal;
import org.aesh.terminal.impl.Pty;
import org.aesh.terminal.utils.ShutdownHooks;
import org.aesh.terminal.utils.Signals;
import org.aesh.tty.Signal;

public class PosixSysTerminal
extends AbstractPosixTerminal {
    protected final InputStream input;
    protected final OutputStream output;
    protected final PrintWriter writer;
    protected final Map<Signal, Object> nativeHandlers = new HashMap<Signal, Object>();
    protected final ShutdownHooks.Task closer;

    public PosixSysTerminal(String name, String type, Pty pty, String encoding, boolean nativeSignals) throws IOException {
        super(name, type, pty);
        assert (encoding != null);
        this.input = pty.getSlaveInput();
        this.output = pty.getSlaveOutput();
        this.writer = new PrintWriter(new OutputStreamWriter(this.output, encoding));
        this.parseInfoCmp();
        if (nativeSignals) {
            for (Signal signal : Signal.values()) {
                this.nativeHandlers.put(signal, Signals.register(signal.name(), () -> this.raise(signal)));
            }
        }
        this.closer = this::close;
        ShutdownHooks.add(this.closer);
    }

    @Override
    public PrintWriter writer() {
        return this.writer;
    }

    @Override
    public InputStream input() {
        return this.input;
    }

    @Override
    public OutputStream output() {
        return this.output;
    }

    @Override
    public void close() throws IOException {
        ShutdownHooks.remove(this.closer);
        for (Map.Entry<Signal, Object> entry : this.nativeHandlers.entrySet()) {
            Signals.unregister(entry.getKey().name(), entry.getValue());
        }
        super.close();
    }
}

