/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.parser;

import org.aesh.parser.LineParser;
import org.aesh.parser.ParsedLine;
import org.aesh.parser.ParsedLineIterator;
import org.aesh.parser.ParsedWord;
import org.aesh.parser.ParserStatus;
import org.junit.Assert;
import org.junit.Test;

public class LineParserTest {
    @Test
    public void testfindCurrentWordFromCursor() {
        Assert.assertEquals((Object)"", (Object)LineParser.parseLine((String)" ", (int)1).selectedWord().word());
        Assert.assertEquals((Object)"foo", (Object)LineParser.parseLine((String)"foo bar", (int)3).selectedWord().word());
        Assert.assertEquals((Object)"bar", (Object)LineParser.parseLine((String)"foo bar", (int)6).selectedWord().word());
        Assert.assertEquals((Object)"foobar", (Object)LineParser.parseLine((String)"foobar", (int)6).selectedWord().word());
        Assert.assertEquals((Object)"fo", (Object)LineParser.parseLine((String)"foobar", (int)2).selectedWordToCursor().word());
        Assert.assertEquals((Object)"", (Object)LineParser.parseLine((String)"ls  ", (int)3).selectedWord().word());
        Assert.assertEquals((Object)"foo", (Object)LineParser.parseLine((String)"ls  foo", (int)6).selectedWord().word());
        Assert.assertEquals((Object)"foo", (Object)LineParser.parseLine((String)"ls  foo bar", (int)6).selectedWord().word());
        Assert.assertEquals((Object)"bar", (Object)LineParser.parseLine((String)"ls  foo bar", (int)11).selectedWordToCursor().word());
        Assert.assertEquals((Object)"ba", (Object)LineParser.parseLine((String)"ls  foo bar", (int)10).selectedWordToCursor().word());
        Assert.assertEquals((Object)"b", (Object)LineParser.parseLine((String)"ls  foo bar", (int)9).selectedWordToCursor().word());
        Assert.assertEquals((Object)"foo", (Object)LineParser.parseLine((String)"ls foo ", (int)6).selectedWordToCursor().word());
        Assert.assertEquals((Object)"o", (Object)LineParser.parseLine((String)"ls o org/jboss/aeshell/Shell.class", (int)4).selectedWord().word());
        Assert.assertEquals((Object)"", (Object)LineParser.parseLine((String)"ls  org/jboss/aeshell/Shell.class", (int)3).selectedWord().word());
    }

    @Test
    public void testFindCurrentWordWithEscapedSpaceToCursor() {
        Assert.assertEquals((Object)"foo bar", (Object)LineParser.parseLine((String)"foo\\ bar", (int)8).selectedWordToCursor().word());
        Assert.assertEquals((Object)"foo ba", (Object)LineParser.parseLine((String)"foo\\ bar", (int)7).selectedWordToCursor().word());
        Assert.assertEquals((Object)"foo bar", (Object)LineParser.parseLine((String)"ls  foo\\ bar", (int)12).selectedWordToCursor().word());
    }

    @Test
    public void testFindClosestWholeWordToCursor() {
        Assert.assertEquals((Object)"foo", (Object)LineParser.parseLine((String)"ls  foo bar", (int)6).selectedWord().word());
        Assert.assertEquals((Object)"", (Object)LineParser.parseLine((String)" ", (int)1).selectedWord().word());
        Assert.assertEquals((Object)"foo", (Object)LineParser.parseLine((String)"foo bar", (int)1).selectedWord().word());
        Assert.assertEquals((Object)"foo", (Object)LineParser.parseLine((String)"foo bar", (int)3).selectedWord().word());
        Assert.assertEquals((Object)"foobar", (Object)LineParser.parseLine((String)"foobar", (int)6).selectedWord().word());
        Assert.assertEquals((Object)"foobar", (Object)LineParser.parseLine((String)"foobar", (int)2).selectedWord().word());
        Assert.assertEquals((Object)"", (Object)LineParser.parseLine((String)"ls  ", (int)3).selectedWord().word());
        Assert.assertEquals((Object)"o", (Object)LineParser.parseLine((String)"ls o org/jboss/aeshell/Shell.class", (int)4).selectedWord().word());
        Assert.assertEquals((Object)"", (Object)LineParser.parseLine((String)"ls  org/jboss/aeshell/Shell.class", (int)3).selectedWord().word());
        Assert.assertEquals((Object)"foo", (Object)LineParser.parseLine((String)"foo bar foo", (int)3).selectedWord().word());
    }

    @Test
    public void testFindClosestWholeWordToCursorEscapedSpace() {
        Assert.assertEquals((Object)"foo bar", (Object)LineParser.parseLine((String)"foo\\ bar", (int)7).selectedWord().word());
        Assert.assertEquals((Object)"foo bar", (Object)LineParser.parseLine((String)"ls  foo\\ bar", (int)11).selectedWord().word());
    }

    @Test
    public void testOriginalInput() {
        String input = "echo foo -i bar";
        ParsedLine line = LineParser.parseLine((String)input);
        Assert.assertEquals((Object)input, (Object)line.line());
    }

    @Test
    public void testFindAllWords() {
        ParsedLine line = LineParser.parseLine((String)"", (int)0);
        Assert.assertEquals((long)-1L, (long)line.wordCursor());
        Assert.assertEquals((long)0L, (long)line.cursor());
        Assert.assertEquals((Object)"", (Object)line.selectedWord().word());
        line = LineParser.parseLine((String)"   foo bar\\ baz 12345 ", (int)5);
        Assert.assertEquals((Object)"foo", (Object)((ParsedWord)line.words().get(0)).word());
        Assert.assertEquals((Object)"bar baz", (Object)((ParsedWord)line.words().get(1)).word());
        Assert.assertEquals((Object)"12345", (Object)((ParsedWord)line.words().get(2)).word());
        Assert.assertEquals((Object)"foo", (Object)line.selectedWord().word());
        Assert.assertEquals((long)2L, (long)line.wordCursor());
        line = LineParser.parseLine((String)"man < foo\\ bar ", (int)14);
        Assert.assertEquals((Object)"man", (Object)((ParsedWord)line.words().get(0)).word());
        Assert.assertEquals((Object)"<", (Object)((ParsedWord)line.words().get(1)).word());
        Assert.assertEquals((Object)"foo bar", (Object)((ParsedWord)line.words().get(2)).word());
        Assert.assertEquals((Object)"foo bar", (Object)line.selectedWord().word());
        Assert.assertEquals((long)7L, (long)line.wordCursor());
        line = LineParser.parseLine((String)"cd A\\ Directory\\ With\\ Spaces", (int)2);
        Assert.assertEquals((Object)"cd", (Object)((ParsedWord)line.words().get(0)).word());
        Assert.assertEquals((Object)"A Directory With Spaces", (Object)((ParsedWord)line.words().get(1)).word());
        Assert.assertEquals((Object)"cd", (Object)line.selectedWord().word());
        Assert.assertEquals((long)2L, (long)line.wordCursor());
        line = LineParser.parseLine((String)"cd A\\ ", (int)5);
        Assert.assertEquals((Object)"cd", (Object)((ParsedWord)line.words().get(0)).word());
        Assert.assertEquals((Object)"A ", (Object)((ParsedWord)line.words().get(1)).word());
        Assert.assertEquals((Object)"A ", (Object)line.selectedWord().word());
        Assert.assertEquals((long)1L, (long)line.wordCursor());
        line = LineParser.parseLine((String)"cd A\\", (int)4);
        Assert.assertEquals((Object)"cd", (Object)((ParsedWord)line.words().get(0)).word());
        Assert.assertEquals((Object)"A\\", (Object)((ParsedWord)line.words().get(1)).word());
        Assert.assertEquals((Object)"A\\", (Object)line.selectedWord().word());
        Assert.assertEquals((long)1L, (long)line.wordCursor());
        line = LineParser.parseLine((String)"ls --files /tmp/A\\ ");
        Assert.assertEquals((Object)"ls", (Object)((ParsedWord)line.words().get(0)).word());
        Assert.assertEquals((Object)"--files", (Object)((ParsedWord)line.words().get(1)).word());
        Assert.assertEquals((Object)"/tmp/A ", (Object)((ParsedWord)line.words().get(2)).word());
        line = LineParser.parseLine((String)"..\\..\\..\\..\\..\\..\\..\\temp\\foo.txt");
        Assert.assertEquals((Object)"..\\..\\..\\..\\..\\..\\..\\temp\\foo.txt", (Object)((ParsedWord)line.words().get(0)).word());
    }

    @Test
    public void testFindAllQuotedWords() {
        ParsedLine line = LineParser.parseLine((String)"foo bar \"baz 12345\" ", (int)19);
        Assert.assertEquals((Object)"foo", (Object)((ParsedWord)line.words().get(0)).word());
        Assert.assertEquals((long)0L, (long)((ParsedWord)line.words().get(0)).lineIndex());
        Assert.assertEquals((Object)"bar", (Object)((ParsedWord)line.words().get(1)).word());
        Assert.assertEquals((long)4L, (long)((ParsedWord)line.words().get(1)).lineIndex());
        Assert.assertEquals((Object)"baz 12345", (Object)((ParsedWord)line.words().get(2)).word());
        Assert.assertEquals((long)9L, (long)((ParsedWord)line.words().get(2)).lineIndex());
        Assert.assertEquals((Object)"", (Object)line.selectedWord().word());
        Assert.assertEquals((long)0L, (long)line.wordCursor());
        line = LineParser.parseLine((String)"java -cp \"foo/bar\" \"Example\"");
        Assert.assertEquals((Object)"foo/bar", (Object)((ParsedWord)line.words().get(2)).word());
        Assert.assertEquals((Object)"Example", (Object)((ParsedWord)line.words().get(3)).word());
        line = LineParser.parseLine((String)"'foo/bar/' Example\\ 1");
        Assert.assertEquals((Object)"foo/bar/", (Object)((ParsedWord)line.words().get(0)).word());
        Assert.assertEquals((Object)"Example 1", (Object)((ParsedWord)line.words().get(1)).word());
        line = LineParser.parseLine((String)"man -f='foo bar/' Example\\ 1 foo");
        Assert.assertEquals((Object)"man", (Object)((ParsedWord)line.words().get(0)).word());
        Assert.assertEquals((Object)"-f=foo bar/", (Object)((ParsedWord)line.words().get(1)).word());
        Assert.assertEquals((Object)"Example 1", (Object)((ParsedWord)line.words().get(2)).word());
        Assert.assertEquals((Object)"foo", (Object)((ParsedWord)line.words().get(3)).word());
        line = LineParser.parseLine((String)"man -f='foo/bar/ Example\\ 1");
        Assert.assertEquals((Object)ParserStatus.UNCLOSED_QUOTE, (Object)line.status());
        line = LineParser.parseLine((String)"man -f='foo/bar/' Example\\ 1\"");
        Assert.assertEquals((Object)ParserStatus.UNCLOSED_QUOTE, (Object)line.status());
        line = LineParser.parseLine((String)"-s 'redirectUris=[\"http://localhost:8080/blah/*\"]'");
        Assert.assertEquals((Object)"-s", (Object)((ParsedWord)line.words().get(0)).word());
        Assert.assertEquals((Object)"redirectUris=[\"http://localhost:8080/blah/*\"]", (Object)((ParsedWord)line.words().get(1)).word());
    }

    @Test
    public void testFindAllTernaryQuotedWords() {
        ParsedLine line = LineParser.parseLine((String)"\"\"  \"\"");
        Assert.assertEquals((Object)"  ", (Object)((ParsedWord)line.words().get(0)).word());
        line = LineParser.parseLine((String)"\"\"  foo bar \"\"");
        Assert.assertEquals((Object)"  foo bar ", (Object)((ParsedWord)line.words().get(0)).word());
        line = LineParser.parseLine((String)"\"\"  \"foo bar\" \"\"");
        Assert.assertEquals((Object)"  \"foo bar\" ", (Object)((ParsedWord)line.words().get(0)).word());
        line = LineParser.parseLine((String)"gah bah-bah  \"\"  \"foo bar\" \"\" boo");
        Assert.assertEquals((Object)"gah", (Object)((ParsedWord)line.words().get(0)).word());
        Assert.assertEquals((Object)"bah-bah", (Object)((ParsedWord)line.words().get(1)).word());
        Assert.assertEquals((Object)"  \"foo bar\" ", (Object)((ParsedWord)line.words().get(2)).word());
        Assert.assertEquals((Object)"boo", (Object)((ParsedWord)line.words().get(3)).word());
        line = LineParser.parseLine((String)" \"\"/s-ramp/wsdl/Operation[xp2:matches(@name, 'submit.*')]\"\"");
        Assert.assertEquals((Object)"/s-ramp/wsdl/Operation[xp2:matches(@name, 'submit.*')]", (Object)((ParsedWord)line.words().get(0)).word());
        line = LineParser.parseLine((String)" \"\"/s-ramp/ext/${type} \\ \"\"");
        Assert.assertEquals((Object)"/s-ramp/ext/${type} \\ ", (Object)((ParsedWord)line.words().get(0)).word());
    }

    @Test
    public void testParsedLineIterator() {
        ParsedLine line = LineParser.parseLine((String)"foo bar");
        ParsedLineIterator iterator = line.iterator();
        int counter = 0;
        while (iterator.hasNextWord()) {
            if (counter == 0) {
                Assert.assertEquals((Object)"foo", (Object)iterator.pollWord());
            } else if (counter == 1) {
                Assert.assertEquals((Object)"bar", (Object)iterator.pollWord());
            }
            ++counter;
        }
        line = LineParser.parseLine((String)"");
        iterator = line.iterator();
        Assert.assertFalse((boolean)iterator.hasNextWord());
        Assert.assertNull((Object)iterator.pollWord());
        line = LineParser.parseLine((String)"\\ foo ba bar");
        iterator = line.iterator();
        Assert.assertEquals((Object)" foo", (Object)iterator.peekWord());
        Assert.assertEquals((Object)" foo", (Object)iterator.pollWord());
        Assert.assertFalse((boolean)iterator.finished());
        Assert.assertEquals((long)98L, (long)iterator.pollChar());
        Assert.assertEquals((long)97L, (long)iterator.pollChar());
        Assert.assertEquals((long)32L, (long)iterator.pollChar());
        Assert.assertFalse((boolean)iterator.finished());
        Assert.assertEquals((Object)"bar", (Object)iterator.peekWord());
        Assert.assertEquals((Object)"bar", (Object)iterator.pollWord());
        Assert.assertTrue((boolean)iterator.finished());
        line = LineParser.parseLine((String)"\\ foo ba bar");
        iterator = line.iterator();
        Assert.assertEquals((long)92L, (long)iterator.pollChar());
        Assert.assertEquals((long)32L, (long)iterator.pollChar());
        Assert.assertEquals((long)102L, (long)iterator.pollChar());
        Assert.assertEquals((Object)" foo", (Object)iterator.pollWord());
        Assert.assertEquals((Object)"ba", (Object)iterator.pollWord());
        Assert.assertEquals((long)98L, (long)iterator.pollChar());
        Assert.assertEquals((long)97L, (long)iterator.pollChar());
        Assert.assertEquals((long)114L, (long)iterator.pollChar());
        Assert.assertTrue((boolean)iterator.finished());
        line = LineParser.parseLine((String)"\\ foo ba bar");
        iterator = line.iterator();
        Assert.assertEquals((Object)" foo", (Object)iterator.pollWord());
    }
}

