/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.impl;

import java.io.IOException;
import java.util.EnumSet;
import org.aesh.terminal.Attributes;
import org.aesh.terminal.impl.ExecPty;
import org.aesh.tty.Size;
import org.junit.Assert;
import org.junit.Test;

public class ExecPtyTest {
    private final String linuxSttySample = "speed 38400 baud; rows 85; columns 244; line = 0;\nintr = ^C; quit = ^\\; erase = ^?; kill = ^U; eof = ^D; eol = M-^?; eol2 = M-^?; swtch = M-^?; start = ^Q; stop = ^S; susp = ^Z; rprnt = ^R; werase = ^W; lnext = ^V; flush = ^O; min = 1; time = 0;\n-parenb -parodd cs8 hupcl -cstopb cread -clocal -crtscts\n-ignbrk brkint -ignpar -parmrk -inpck -istrip -inlcr -igncr icrnl ixon -ixoff -iuclc ixany imaxbel iutf8\nopost -olcuc -ocrnl onlcr -onocr -onlret -ofill -ofdel nl0 cr0 tab0 bs0 vt0 ff0\nisig icanon iexten echo echoe echok -echonl -noflsh -xcase -tostop -echoprt echoctl echoke";
    private final String solarisSttySample = "speed 38400 baud; \nrows = 85; columns = 244; ypixels = 0; xpixels = 0;\ncsdata ?\neucw 1:0:0:0, scrw 1:0:0:0\nintr = ^c; quit = ^\\; erase = ^?; kill = ^u;\neof = ^d; eol = -^?; eol2 = -^?; swtch = <undef>;\nstart = ^q; stop = ^s; susp = ^z; dsusp = ^y;\nrprnt = ^r; flush = ^o; werase = ^w; lnext = ^v;\n-parenb -parodd cs8 -cstopb -hupcl cread -clocal -loblk -crtscts -crtsxoff -parext \n-ignbrk brkint -ignpar -parmrk -inpck -istrip -inlcr -igncr icrnl -iuclc \nixon ixany -ixoff imaxbel \nisig icanon -xcase echo echoe echok -echonl -noflsh \n-tostop echoctl -echoprt echoke -defecho -flusho -pendin iexten \nopost -olcuc onlcr -ocrnl -onocr -onlret -ofill -ofdel tab3";
    private final String aixSttySample = "speed 38400 baud; 85 rows; 244 columns;\neucw 1:1:0:0, scrw 1:1:0:0:\nintr = ^C; quit = ^\\; erase = ^?; kill = ^U; eof = ^D; eol = <undef>\neol2 = <undef>; start = ^Q; stop = ^S; susp = ^Z; dsusp = ^Y; reprint = ^R\ndiscard = ^O; werase = ^W; lnext = ^V\n-parenb -parodd cs8 -cstopb -hupcl cread -clocal -parext \n-ignbrk brkint -ignpar -parmrk -inpck -istrip -inlcr -igncr icrnl -iuclc \nixon ixany -ixoff imaxbel \nisig icanon -xcase echo echoe echok -echonl -noflsh \n-tostop echoctl -echoprt echoke -flusho -pending iexten \nopost -olcuc onlcr -ocrnl -onocr -onlret -ofill -ofdel tab3";
    private final String macOsSttySample = "speed 9600 baud; 85 rows; 244 columns;\nlflags: icanon isig iexten echo echoe -echok echoke -echonl echoctl\n-echoprt -altwerase -noflsh -tostop -flusho pendin -nokerninfo\n-extproc\niflags: -istrip icrnl -inlcr -igncr ixon -ixoff ixany imaxbel iutf8\n-ignbrk brkint -inpck -ignpar -parmrk\noflags: opost onlcr -oxtabs -onocr -onlret\ncflags: cread cs8 -parenb -parodd hupcl -clocal -cstopb -crtscts -dsrflow\n-dtrflow -mdmbuf\ncchars: discard = ^O; dsusp = ^Y; eof = ^D; eol = <undef>;\neol2 = <undef>; erase = ^?; intr = ^C; kill = ^U; lnext = ^V;\nmin = 1; quit = ^\\; reprint = ^R; start = ^Q; status = ^T;\nstop = ^S; susp = ^Z; time = 0; werase = ^W;";
    private final String netBsdSttySample = "speed 38400 baud; 85 rows; 244 columns;\nlflags: icanon isig iexten echo echoe echok echoke -echonl echoctl\n        -echoprt -altwerase -noflsh -tostop -flusho pendin -nokerninfo\n        -extproc\niflags: -istrip icrnl -inlcr -igncr ixon -ixoff ixany imaxbel -ignbrk\n        brkint -inpck -ignpar -parmrk\noflags: opost onlcr -ocrnl oxtabs onocr onlret\ncflags: cread cs8 -parenb -parodd hupcl -clocal -cstopb -crtscts -mdmbuf\n        -cdtrcts\ncchars: discard = ^O; dsusp = ^Y; eof = ^D; eol = <undef>;\n        eol2 = <undef>; erase = ^?; intr = ^C; kill = ^U; lnext = ^V;\n        min = 1; quit = ^\\; reprint = ^R; start = ^Q; status = ^T;\n        stop = ^S; susp = ^Z; time = 0; werase = ^W;";
    private final String freeBsdSttySample = "speed 9600 baud; 85 rows; 244 columns;\nlflags: icanon isig iexten echo echoe echok echoke -echonl echoctl\n        -echoprt -altwerase -noflsh -tostop -flusho -pendin -nokerninfo\n        -extproc\niflags: -istrip icrnl -inlcr -igncr ixon -ixoff ixany imaxbel -ignbrk\n        brkint -inpck -ignpar -parmrk\noflags: opost onlcr -ocrnl tab0 -onocr -onlret\ncflags: cread cs8 -parenb -parodd hupcl -clocal -cstopb -crtscts -dsrflow\n        -dtrflow -mdmbuf\ncchars: discard = ^O; dsusp = ^Y; eof = ^D; eol = <undef>;\n        eol2 = <undef>; erase = ^?; erase2 = ^H; intr = ^C; kill = ^U;\n        lnext = ^V; min = 1; quit = ^\\; reprint = ^R; start = ^Q;\n        status = ^T; stop = ^S; susp = ^Z; time = 0; werase = ^W;";
    private final String hpuxSttySample = "speed 38400 baud; line = 0;\nrows = 85; columns = 244\nmin = 4; time = 0;\nintr = DEL; quit = ^\\; erase = #; kill = @\neof = ^D; eol = ^@; eol2 <undef>; swtch = ^@\nstop = ^S; start = ^Q; susp <undef>; dsusp <undef>\nwerase <undef>; lnext <undef>\n-parenb -parodd cs8 -cstopb hupcl cread -clocal -loblk -crts\n-ignbrk brkint ignpar -parmrk -inpck istrip -inlcr -igncr icrnl -iuclc\nixon ixany -ixoff -imaxbel -rtsxoff -ctsxon -ienqak\nisig icanon -iexten -xcase echo -echoe echok -echonl -noflsh\n-echoctl -echoprt -echoke -flusho -pendin\nopost -olcuc onlcr -ocrnl -onocr -onlret -ofill -ofdel -tostop";

    @Test
    public void testParseSize() throws IOException {
        Assert.assertEquals((Object)new Size(244, 85), (Object)ExecPty.doGetSize((String)"speed 38400 baud; rows 85; columns 244; line = 0;\nintr = ^C; quit = ^\\; erase = ^?; kill = ^U; eof = ^D; eol = M-^?; eol2 = M-^?; swtch = M-^?; start = ^Q; stop = ^S; susp = ^Z; rprnt = ^R; werase = ^W; lnext = ^V; flush = ^O; min = 1; time = 0;\n-parenb -parodd cs8 hupcl -cstopb cread -clocal -crtscts\n-ignbrk brkint -ignpar -parmrk -inpck -istrip -inlcr -igncr icrnl ixon -ixoff -iuclc ixany imaxbel iutf8\nopost -olcuc -ocrnl onlcr -onocr -onlret -ofill -ofdel nl0 cr0 tab0 bs0 vt0 ff0\nisig icanon iexten echo echoe echok -echonl -noflsh -xcase -tostop -echoprt echoctl echoke"));
        Assert.assertEquals((Object)new Size(244, 85), (Object)ExecPty.doGetSize((String)"speed 38400 baud; \nrows = 85; columns = 244; ypixels = 0; xpixels = 0;\ncsdata ?\neucw 1:0:0:0, scrw 1:0:0:0\nintr = ^c; quit = ^\\; erase = ^?; kill = ^u;\neof = ^d; eol = -^?; eol2 = -^?; swtch = <undef>;\nstart = ^q; stop = ^s; susp = ^z; dsusp = ^y;\nrprnt = ^r; flush = ^o; werase = ^w; lnext = ^v;\n-parenb -parodd cs8 -cstopb -hupcl cread -clocal -loblk -crtscts -crtsxoff -parext \n-ignbrk brkint -ignpar -parmrk -inpck -istrip -inlcr -igncr icrnl -iuclc \nixon ixany -ixoff imaxbel \nisig icanon -xcase echo echoe echok -echonl -noflsh \n-tostop echoctl -echoprt echoke -defecho -flusho -pendin iexten \nopost -olcuc onlcr -ocrnl -onocr -onlret -ofill -ofdel tab3"));
        Assert.assertEquals((Object)new Size(244, 85), (Object)ExecPty.doGetSize((String)"speed 38400 baud; 85 rows; 244 columns;\neucw 1:1:0:0, scrw 1:1:0:0:\nintr = ^C; quit = ^\\; erase = ^?; kill = ^U; eof = ^D; eol = <undef>\neol2 = <undef>; start = ^Q; stop = ^S; susp = ^Z; dsusp = ^Y; reprint = ^R\ndiscard = ^O; werase = ^W; lnext = ^V\n-parenb -parodd cs8 -cstopb -hupcl cread -clocal -parext \n-ignbrk brkint -ignpar -parmrk -inpck -istrip -inlcr -igncr icrnl -iuclc \nixon ixany -ixoff imaxbel \nisig icanon -xcase echo echoe echok -echonl -noflsh \n-tostop echoctl -echoprt echoke -flusho -pending iexten \nopost -olcuc onlcr -ocrnl -onocr -onlret -ofill -ofdel tab3"));
        Assert.assertEquals((Object)new Size(244, 85), (Object)ExecPty.doGetSize((String)"speed 9600 baud; 85 rows; 244 columns;\nlflags: icanon isig iexten echo echoe -echok echoke -echonl echoctl\n-echoprt -altwerase -noflsh -tostop -flusho pendin -nokerninfo\n-extproc\niflags: -istrip icrnl -inlcr -igncr ixon -ixoff ixany imaxbel iutf8\n-ignbrk brkint -inpck -ignpar -parmrk\noflags: opost onlcr -oxtabs -onocr -onlret\ncflags: cread cs8 -parenb -parodd hupcl -clocal -cstopb -crtscts -dsrflow\n-dtrflow -mdmbuf\ncchars: discard = ^O; dsusp = ^Y; eof = ^D; eol = <undef>;\neol2 = <undef>; erase = ^?; intr = ^C; kill = ^U; lnext = ^V;\nmin = 1; quit = ^\\; reprint = ^R; start = ^Q; status = ^T;\nstop = ^S; susp = ^Z; time = 0; werase = ^W;"));
        Assert.assertEquals((Object)new Size(244, 85), (Object)ExecPty.doGetSize((String)"speed 38400 baud; 85 rows; 244 columns;\nlflags: icanon isig iexten echo echoe echok echoke -echonl echoctl\n        -echoprt -altwerase -noflsh -tostop -flusho pendin -nokerninfo\n        -extproc\niflags: -istrip icrnl -inlcr -igncr ixon -ixoff ixany imaxbel -ignbrk\n        brkint -inpck -ignpar -parmrk\noflags: opost onlcr -ocrnl oxtabs onocr onlret\ncflags: cread cs8 -parenb -parodd hupcl -clocal -cstopb -crtscts -mdmbuf\n        -cdtrcts\ncchars: discard = ^O; dsusp = ^Y; eof = ^D; eol = <undef>;\n        eol2 = <undef>; erase = ^?; intr = ^C; kill = ^U; lnext = ^V;\n        min = 1; quit = ^\\; reprint = ^R; start = ^Q; status = ^T;\n        stop = ^S; susp = ^Z; time = 0; werase = ^W;"));
        Assert.assertEquals((Object)new Size(244, 85), (Object)ExecPty.doGetSize((String)"speed 9600 baud; 85 rows; 244 columns;\nlflags: icanon isig iexten echo echoe echok echoke -echonl echoctl\n        -echoprt -altwerase -noflsh -tostop -flusho -pendin -nokerninfo\n        -extproc\niflags: -istrip icrnl -inlcr -igncr ixon -ixoff ixany imaxbel -ignbrk\n        brkint -inpck -ignpar -parmrk\noflags: opost onlcr -ocrnl tab0 -onocr -onlret\ncflags: cread cs8 -parenb -parodd hupcl -clocal -cstopb -crtscts -dsrflow\n        -dtrflow -mdmbuf\ncchars: discard = ^O; dsusp = ^Y; eof = ^D; eol = <undef>;\n        eol2 = <undef>; erase = ^?; erase2 = ^H; intr = ^C; kill = ^U;\n        lnext = ^V; min = 1; quit = ^\\; reprint = ^R; start = ^Q;\n        status = ^T; stop = ^S; susp = ^Z; time = 0; werase = ^W;"));
        Assert.assertEquals((Object)new Size(244, 85), (Object)ExecPty.doGetSize((String)"speed 38400 baud; line = 0;\nrows = 85; columns = 244\nmin = 4; time = 0;\nintr = DEL; quit = ^\\; erase = #; kill = @\neof = ^D; eol = ^@; eol2 <undef>; swtch = ^@\nstop = ^S; start = ^Q; susp <undef>; dsusp <undef>\nwerase <undef>; lnext <undef>\n-parenb -parodd cs8 -cstopb hupcl cread -clocal -loblk -crts\n-ignbrk brkint ignpar -parmrk -inpck istrip -inlcr -igncr icrnl -iuclc\nixon ixany -ixoff -imaxbel -rtsxoff -ctsxon -ienqak\nisig icanon -iexten -xcase echo -echoe echok -echonl -noflsh\n-echoctl -echoprt -echoke -flusho -pendin\nopost -olcuc onlcr -ocrnl -onocr -onlret -ofill -ofdel -tostop"));
    }

    @Test
    public void testParseAttributesLinux() throws IOException {
        Attributes attributes = ExecPty.doGetAttr((String)"speed 38400 baud; rows 85; columns 244; line = 0;\nintr = ^C; quit = ^\\; erase = ^?; kill = ^U; eof = ^D; eol = M-^?; eol2 = M-^?; swtch = M-^?; start = ^Q; stop = ^S; susp = ^Z; rprnt = ^R; werase = ^W; lnext = ^V; flush = ^O; min = 1; time = 0;\n-parenb -parodd cs8 hupcl -cstopb cread -clocal -crtscts\n-ignbrk brkint -ignpar -parmrk -inpck -istrip -inlcr -igncr icrnl ixon -ixoff -iuclc ixany imaxbel iutf8\nopost -olcuc -ocrnl onlcr -onocr -onlret -ofill -ofdel nl0 cr0 tab0 bs0 vt0 ff0\nisig icanon iexten echo echoe echok -echonl -noflsh -xcase -tostop -echoprt echoctl echoke");
        Assert.assertEquals(EnumSet.of(Attributes.InputFlag.BRKINT, new Attributes.InputFlag[]{Attributes.InputFlag.ICRNL, Attributes.InputFlag.IXON, Attributes.InputFlag.IXANY, Attributes.InputFlag.IMAXBEL, Attributes.InputFlag.IUTF8}), (Object)attributes.getInputFlags());
        Assert.assertEquals(EnumSet.of(Attributes.OutputFlag.OPOST, Attributes.OutputFlag.ONLCR), (Object)attributes.getOutputFlags());
        Assert.assertEquals(EnumSet.of(Attributes.ControlFlag.CREAD, Attributes.ControlFlag.HUPCL, Attributes.ControlFlag.CS8), (Object)attributes.getControlFlags());
        Assert.assertEquals(EnumSet.of(Attributes.LocalFlag.ISIG, new Attributes.LocalFlag[]{Attributes.LocalFlag.ICANON, Attributes.LocalFlag.IEXTEN, Attributes.LocalFlag.ECHO, Attributes.LocalFlag.ECHOK, Attributes.LocalFlag.ECHOCTL, Attributes.LocalFlag.ECHOKE, Attributes.LocalFlag.ECHOE}), (Object)attributes.getLocalFlags());
        Assert.assertEquals((long)ExecPty.parseControlChar((String)"^C"), (long)attributes.getControlChar(Attributes.ControlChar.VINTR));
        Assert.assertEquals((long)ExecPty.parseControlChar((String)"^\\"), (long)attributes.getControlChar(Attributes.ControlChar.VQUIT));
        Assert.assertEquals((long)ExecPty.parseControlChar((String)"^?"), (long)attributes.getControlChar(Attributes.ControlChar.VERASE));
        Assert.assertEquals((long)ExecPty.parseControlChar((String)"^U"), (long)attributes.getControlChar(Attributes.ControlChar.VKILL));
        Assert.assertEquals((long)ExecPty.parseControlChar((String)"^D"), (long)attributes.getControlChar(Attributes.ControlChar.VEOF));
        Assert.assertEquals((long)ExecPty.parseControlChar((String)"M-^?"), (long)attributes.getControlChar(Attributes.ControlChar.VEOL));
        Assert.assertEquals((long)ExecPty.parseControlChar((String)"M-^?"), (long)attributes.getControlChar(Attributes.ControlChar.VEOL2));
        Assert.assertEquals((long)ExecPty.parseControlChar((String)"^Q"), (long)attributes.getControlChar(Attributes.ControlChar.VSTART));
        Assert.assertEquals((long)ExecPty.parseControlChar((String)"^S"), (long)attributes.getControlChar(Attributes.ControlChar.VSTOP));
        Assert.assertEquals((long)ExecPty.parseControlChar((String)"^Z"), (long)attributes.getControlChar(Attributes.ControlChar.VSUSP));
        Assert.assertEquals((long)ExecPty.parseControlChar((String)"^R"), (long)attributes.getControlChar(Attributes.ControlChar.VREPRINT));
        Assert.assertEquals((long)ExecPty.parseControlChar((String)"^W"), (long)attributes.getControlChar(Attributes.ControlChar.VWERASE));
        Assert.assertEquals((long)ExecPty.parseControlChar((String)"^V"), (long)attributes.getControlChar(Attributes.ControlChar.VLNEXT));
        Assert.assertEquals((long)1L, (long)attributes.getControlChar(Attributes.ControlChar.VMIN));
        Assert.assertEquals((long)0L, (long)attributes.getControlChar(Attributes.ControlChar.VTIME));
    }

    @Test
    public void testParseAttributesSolaris() throws IOException {
        Attributes attributes = ExecPty.doGetAttr((String)"speed 38400 baud; \nrows = 85; columns = 244; ypixels = 0; xpixels = 0;\ncsdata ?\neucw 1:0:0:0, scrw 1:0:0:0\nintr = ^c; quit = ^\\; erase = ^?; kill = ^u;\neof = ^d; eol = -^?; eol2 = -^?; swtch = <undef>;\nstart = ^q; stop = ^s; susp = ^z; dsusp = ^y;\nrprnt = ^r; flush = ^o; werase = ^w; lnext = ^v;\n-parenb -parodd cs8 -cstopb -hupcl cread -clocal -loblk -crtscts -crtsxoff -parext \n-ignbrk brkint -ignpar -parmrk -inpck -istrip -inlcr -igncr icrnl -iuclc \nixon ixany -ixoff imaxbel \nisig icanon -xcase echo echoe echok -echonl -noflsh \n-tostop echoctl -echoprt echoke -defecho -flusho -pendin iexten \nopost -olcuc onlcr -ocrnl -onocr -onlret -ofill -ofdel tab3");
        Assert.assertEquals(EnumSet.of(Attributes.InputFlag.BRKINT, Attributes.InputFlag.ICRNL, Attributes.InputFlag.IXON, Attributes.InputFlag.IXANY, Attributes.InputFlag.IMAXBEL), (Object)attributes.getInputFlags());
        Assert.assertEquals(EnumSet.of(Attributes.OutputFlag.OPOST, Attributes.OutputFlag.ONLCR), (Object)attributes.getOutputFlags());
        Assert.assertEquals(EnumSet.of(Attributes.ControlFlag.CREAD, Attributes.ControlFlag.CS8), (Object)attributes.getControlFlags());
        Assert.assertEquals(EnumSet.of(Attributes.LocalFlag.ISIG, new Attributes.LocalFlag[]{Attributes.LocalFlag.ICANON, Attributes.LocalFlag.IEXTEN, Attributes.LocalFlag.ECHO, Attributes.LocalFlag.ECHOK, Attributes.LocalFlag.ECHOCTL, Attributes.LocalFlag.ECHOKE, Attributes.LocalFlag.ECHOE}), (Object)attributes.getLocalFlags());
        Assert.assertEquals((long)ExecPty.parseControlChar((String)"^C"), (long)attributes.getControlChar(Attributes.ControlChar.VINTR));
        Assert.assertEquals((long)ExecPty.parseControlChar((String)"^\\"), (long)attributes.getControlChar(Attributes.ControlChar.VQUIT));
        Assert.assertEquals((long)ExecPty.parseControlChar((String)"^?"), (long)attributes.getControlChar(Attributes.ControlChar.VERASE));
        Assert.assertEquals((long)ExecPty.parseControlChar((String)"^U"), (long)attributes.getControlChar(Attributes.ControlChar.VKILL));
        Assert.assertEquals((long)ExecPty.parseControlChar((String)"^D"), (long)attributes.getControlChar(Attributes.ControlChar.VEOF));
        Assert.assertEquals((long)ExecPty.parseControlChar((String)"-^?"), (long)attributes.getControlChar(Attributes.ControlChar.VEOL));
        Assert.assertEquals((long)ExecPty.parseControlChar((String)"-^?"), (long)attributes.getControlChar(Attributes.ControlChar.VEOL2));
        Assert.assertEquals((long)ExecPty.parseControlChar((String)"^Q"), (long)attributes.getControlChar(Attributes.ControlChar.VSTART));
        Assert.assertEquals((long)ExecPty.parseControlChar((String)"^S"), (long)attributes.getControlChar(Attributes.ControlChar.VSTOP));
        Assert.assertEquals((long)ExecPty.parseControlChar((String)"^Z"), (long)attributes.getControlChar(Attributes.ControlChar.VSUSP));
        Assert.assertEquals((long)ExecPty.parseControlChar((String)"^R"), (long)attributes.getControlChar(Attributes.ControlChar.VREPRINT));
        Assert.assertEquals((long)ExecPty.parseControlChar((String)"^W"), (long)attributes.getControlChar(Attributes.ControlChar.VWERASE));
        Assert.assertEquals((long)ExecPty.parseControlChar((String)"^V"), (long)attributes.getControlChar(Attributes.ControlChar.VLNEXT));
    }

    @Test
    public void testParseAttributesHpux() throws IOException {
        Attributes attributes = ExecPty.doGetAttr((String)"speed 38400 baud; line = 0;\nrows = 85; columns = 244\nmin = 4; time = 0;\nintr = DEL; quit = ^\\; erase = #; kill = @\neof = ^D; eol = ^@; eol2 <undef>; swtch = ^@\nstop = ^S; start = ^Q; susp <undef>; dsusp <undef>\nwerase <undef>; lnext <undef>\n-parenb -parodd cs8 -cstopb hupcl cread -clocal -loblk -crts\n-ignbrk brkint ignpar -parmrk -inpck istrip -inlcr -igncr icrnl -iuclc\nixon ixany -ixoff -imaxbel -rtsxoff -ctsxon -ienqak\nisig icanon -iexten -xcase echo -echoe echok -echonl -noflsh\n-echoctl -echoprt -echoke -flusho -pendin\nopost -olcuc onlcr -ocrnl -onocr -onlret -ofill -ofdel -tostop");
        Assert.assertEquals(EnumSet.of(Attributes.InputFlag.BRKINT, new Attributes.InputFlag[]{Attributes.InputFlag.IGNPAR, Attributes.InputFlag.ISTRIP, Attributes.InputFlag.ICRNL, Attributes.InputFlag.IXON, Attributes.InputFlag.IXANY}), (Object)attributes.getInputFlags());
        Assert.assertEquals(EnumSet.of(Attributes.OutputFlag.OPOST, Attributes.OutputFlag.ONLCR), (Object)attributes.getOutputFlags());
        Assert.assertEquals(EnumSet.of(Attributes.ControlFlag.CREAD, Attributes.ControlFlag.CS8, Attributes.ControlFlag.HUPCL), (Object)attributes.getControlFlags());
        Assert.assertEquals(EnumSet.of(Attributes.LocalFlag.ISIG, Attributes.LocalFlag.ICANON, Attributes.LocalFlag.ECHO, Attributes.LocalFlag.ECHOK), (Object)attributes.getLocalFlags());
        Assert.assertEquals((long)127L, (long)attributes.getControlChar(Attributes.ControlChar.VINTR));
        Assert.assertEquals((long)ExecPty.parseControlChar((String)"^\\"), (long)attributes.getControlChar(Attributes.ControlChar.VQUIT));
        Assert.assertEquals((long)35L, (long)attributes.getControlChar(Attributes.ControlChar.VERASE));
        Assert.assertEquals((long)64L, (long)attributes.getControlChar(Attributes.ControlChar.VKILL));
        Assert.assertEquals((long)ExecPty.parseControlChar((String)"^D"), (long)attributes.getControlChar(Attributes.ControlChar.VEOF));
        Assert.assertEquals((long)0L, (long)attributes.getControlChar(Attributes.ControlChar.VEOL));
        Assert.assertEquals((long)ExecPty.parseControlChar((String)"^Q"), (long)attributes.getControlChar(Attributes.ControlChar.VSTART));
        Assert.assertEquals((long)ExecPty.parseControlChar((String)"^S"), (long)attributes.getControlChar(Attributes.ControlChar.VSTOP));
        Assert.assertEquals((long)4L, (long)attributes.getControlChar(Attributes.ControlChar.VMIN));
        Assert.assertEquals((long)0L, (long)attributes.getControlChar(Attributes.ControlChar.VTIME));
    }
}

