/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline;

import java.io.IOException;
import java.util.function.Consumer;
import org.aesh.readline.AeshConsoleBuffer;
import org.aesh.readline.ConsoleBuffer;
import org.aesh.readline.Prompt;
import org.aesh.readline.editing.EditModeBuilder;
import org.aesh.readline.history.History;
import org.aesh.readline.history.InMemoryHistory;
import org.aesh.terminal.Connection;
import org.aesh.terminal.tty.Capability;
import org.aesh.terminal.tty.Signal;
import org.aesh.terminal.tty.Size;
import org.aesh.util.ANSI;
import org.aesh.util.Parser;
import org.junit.Assert;
import org.junit.Test;

public class ConsoleBufferTest {
    private ConsoleBuffer createConsoleBuffer(Connection connection) {
        return new AeshConsoleBuffer(connection, new Prompt("[aesh@rules]: "), EditModeBuilder.builder().create(), (History)new InMemoryHistory(50), null, connection.size(), true);
    }

    private ConsoleBuffer createConsoleBuffer(Connection connection, String prompt) {
        return new AeshConsoleBuffer(connection, new Prompt(prompt), EditModeBuilder.builder().create(), (History)new InMemoryHistory(50), null, connection.size(), true);
    }

    @Test
    public void testSimpleWrites() throws IOException {
        SimpleConnection connection = new SimpleConnection();
        ConsoleBuffer consoleBuffer = this.createConsoleBuffer(connection);
        consoleBuffer.drawLine();
        Assert.assertTrue((boolean)connection.bufferBuilder.toString().contains("aesh"));
        connection.bufferBuilder.delete(0, connection.bufferBuilder.length());
        consoleBuffer.writeString("foo");
        Assert.assertEquals((Object)"foo", (Object)connection.bufferBuilder.toString());
        consoleBuffer.writeString("OOO");
        Assert.assertEquals((Object)"fooOOO", (Object)connection.bufferBuilder.toString());
    }

    @Test
    public void testMovement() throws IOException {
        SimpleConnection connection = new SimpleConnection();
        ConsoleBuffer consoleBuffer = this.createConsoleBuffer(connection, "");
        consoleBuffer.writeString("foo0");
        consoleBuffer.moveCursor(-1);
        Assert.assertEquals((Object)("foo0" + Parser.fromCodePoints((int[])ANSI.printAnsi((String)"1D"))), (Object)connection.bufferBuilder.toString());
        consoleBuffer.moveCursor(-10);
        Assert.assertEquals((Object)("foo0" + Parser.fromCodePoints((int[])ANSI.printAnsi((String)"1D")) + Parser.fromCodePoints((int[])ANSI.printAnsi((String)"2D"))), (Object)connection.bufferBuilder.toString());
        consoleBuffer.writeString("1");
        Assert.assertEquals((Object)"1foo0", (Object)consoleBuffer.buffer().asString());
        connection.bufferBuilder.delete(0, connection.bufferBuilder.length());
        consoleBuffer.moveCursor(1);
        Assert.assertEquals((Object)Parser.fromCodePoints((int[])ANSI.printAnsi((String)"1C")), (Object)connection.bufferBuilder.toString());
        consoleBuffer.writeString("2");
        Assert.assertEquals((Object)"1f2oo0", (Object)consoleBuffer.buffer().asString());
    }

    class SimpleConnection
    implements Connection {
        private Consumer<Size> sizeHandler;
        private Consumer<int[]> stdOutHandler;
        private StringBuilder bufferBuilder = new StringBuilder();

        SimpleConnection() {
            this.stdOutHandler = ints -> this.bufferBuilder.append(Parser.fromCodePoints((int[])ints));
        }

        public String getBuffer() {
            return this.bufferBuilder.toString();
        }

        public String terminalType() {
            return null;
        }

        public Size size() {
            return new Size(80, 20);
        }

        public Consumer<Size> getSizeHandler() {
            return null;
        }

        public void setSizeHandler(Consumer<Size> handler) {
        }

        public Consumer<Signal> getSignalHandler() {
            return null;
        }

        public void setSignalHandler(Consumer<Signal> handler) {
        }

        public Consumer<int[]> getStdinHandler() {
            return null;
        }

        public void setStdinHandler(Consumer<int[]> handler) {
        }

        public Consumer<int[]> stdoutHandler() {
            return this.stdOutHandler;
        }

        public void setCloseHandler(Consumer<Void> closeHandler) {
        }

        public Consumer<Void> getCloseHandler() {
            return null;
        }

        public void close() {
        }

        public void openBlocking() {
        }

        public void openNonBlocking() {
        }

        public void stopReading() {
        }

        public void suspend() {
        }

        public boolean suspended() {
            return false;
        }

        public void awake() {
        }

        public boolean put(Capability capability, Object ... params) {
            return false;
        }
    }
}

