/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.terminal.utils;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import org.aesh.readline.terminal.utils.InfoCmp;
import org.aesh.terminal.tty.Capability;
import org.aesh.util.Config;
import org.junit.Assert;
import org.junit.Test;

public class InfoCmpTest {
    @Test
    public void testANSI() {
        HashSet bools = new HashSet();
        HashMap ints = new HashMap();
        HashMap strings = new HashMap();
        String infocmp = InfoCmp.getDefaultInfoCmp((String)"xterm");
        InfoCmp.parseInfoCmp((String)infocmp, bools, ints, strings);
        Assert.assertEquals((long)24L, (long)((Integer)ints.get(Capability.lines)).intValue());
        Assert.assertEquals((long)80L, (long)((Integer)ints.get(Capability.columns)).intValue());
        Assert.assertEquals((long)5L, (long)ints.size());
        Assert.assertEquals((long)8L, (long)bools.size());
        Assert.assertEquals((long)166L, (long)strings.size());
        Assert.assertTrue((boolean)strings.containsKey(Capability.byName((String)"kf29")));
    }

    @Test
    public void testWindows() {
        HashSet bools = new HashSet();
        HashMap ints = new HashMap();
        HashMap strings = new HashMap();
        String infocmp = InfoCmp.getDefaultInfoCmp((String)"Windows");
        InfoCmp.parseInfoCmp((String)infocmp, bools, ints, strings);
        Assert.assertEquals((long)24L, (long)((Integer)ints.get(Capability.lines)).intValue());
        Assert.assertEquals((long)64L, (long)((Integer)ints.get(Capability.max_pairs)).intValue());
        Assert.assertEquals((long)6L, (long)ints.size());
        Assert.assertEquals((long)4L, (long)bools.size());
        Assert.assertEquals((long)58L, (long)strings.size());
        Assert.assertTrue((boolean)strings.containsKey(Capability.byName((String)"smso")));
    }

    @Test
    public void testNative() throws IOException, InterruptedException {
        if (Config.isOSPOSIXCompatible()) {
            HashSet bools = new HashSet();
            HashMap ints = new HashMap();
            HashMap strings = new HashMap();
            String infocmp = InfoCmp.getInfoCmp((String)"xterm-256color");
            if (infocmp != null) {
                InfoCmp.parseInfoCmp((String)infocmp, bools, ints, strings);
                Assert.assertEquals((long)256L, (long)((Integer)ints.get(Capability.max_colors)).intValue());
                Assert.assertTrue(((Integer)ints.get(Capability.columns) > 0 ? 1 : 0) != 0);
                Assert.assertTrue(((Integer)ints.get(Capability.lines) > 0 ? 1 : 0) != 0);
                Assert.assertTrue((bools.size() > 0 ? 1 : 0) != 0);
                Assert.assertTrue((strings.size() > 0 ? 1 : 0) != 0);
            }
        }
    }
}

