/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.alias;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import org.aesh.readline.Prompt;
import org.aesh.readline.Readline;
import org.aesh.readline.alias.AliasManager;
import org.aesh.readline.alias.AliasPreProcessor;
import org.aesh.readline.tty.terminal.TerminalConnection;
import org.aesh.terminal.Connection;
import org.aesh.util.Config;
import org.junit.Assert;
import org.junit.Test;

public class ReadlineAliasTest {
    @Test
    public void alias() throws Exception {
        PipedOutputStream outputStream = new PipedOutputStream();
        PipedInputStream pipedInputStream = new PipedInputStream(outputStream);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TerminalConnection connection = new TerminalConnection((InputStream)pipedInputStream, (OutputStream)out);
        Readline readline = new Readline();
        File aliasFile = Config.isOSPOSIXCompatible() ? new File("src/test/resources/alias1") : new File("src\\test\\resources\\alias1");
        AliasManager aliasManager = new AliasManager(aliasFile, false);
        AliasPreProcessor aliasPreProcessor = new AliasPreProcessor(aliasManager);
        ArrayList<AliasPreProcessor> preProcessors = new ArrayList<AliasPreProcessor>();
        preProcessors.add(aliasPreProcessor);
        readline.readline((Connection)connection, new Prompt(""), s -> {
            Assert.assertEquals((Object)"ls -alF", (Object)s);
            readline.readline((Connection)connection, new Prompt(""), t -> Assert.assertEquals((Object)"grep --color=auto -l", (Object)t), null, preProcessors);
        }, null, preProcessors);
        outputStream.write(("ll" + Config.getLineSeparator()).getBytes());
        outputStream.write(("grep -l" + Config.getLineSeparator()).getBytes());
        outputStream.flush();
        connection.openNonBlocking();
        Thread.sleep(200L);
    }
}

