/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.editing;

import org.aesh.readline.action.KeyAction;
import org.aesh.readline.action.mappings.BackwardChar;
import org.aesh.readline.action.mappings.BeginningOfLine;
import org.aesh.readline.action.mappings.DeletePrevChar;
import org.aesh.readline.action.mappings.EndOfLine;
import org.aesh.readline.action.mappings.ForwardChar;
import org.aesh.readline.action.mappings.NextHistory;
import org.aesh.readline.action.mappings.NoAction;
import org.aesh.readline.action.mappings.PrevHistory;
import org.aesh.readline.editing.EditModeBuilder;
import org.aesh.readline.editing.InputrcParser;
import org.aesh.readline.terminal.Key;
import org.aesh.util.Config;
import org.junit.Assert;
import org.junit.Test;

public class KeyMapperTest {
    @Test
    public void testQuoteMapKeys() {
        if (Config.isOSPOSIXCompatible()) {
            EditModeBuilder builder = EditModeBuilder.builder();
            InputrcParser.parseLine((String)"\"\\M-a\":   meta", (EditModeBuilder)builder);
            Assert.assertEquals((Object)builder.create().parse((KeyAction)Key.META_a).name(), (Object)new NoAction().name());
            InputrcParser.parseLine((String)"\"\\M-[D\": backward-char", (EditModeBuilder)builder);
            Assert.assertEquals((Object)builder.create().parse((KeyAction)Key.LEFT).name(), (Object)new BackwardChar().name());
            InputrcParser.parseLine((String)"\"\\M-[C\": forward-char", (EditModeBuilder)builder);
            Assert.assertEquals((Object)builder.create().parse((KeyAction)Key.RIGHT).name(), (Object)new ForwardChar().name());
            InputrcParser.parseLine((String)"\"\\M-[A\": previous-history", (EditModeBuilder)builder);
            Assert.assertEquals((Object)builder.create().parse((KeyAction)Key.UP).name(), (Object)new PrevHistory().name());
            InputrcParser.parseLine((String)"\"\\M-[B\": next-history", (EditModeBuilder)builder);
            Assert.assertEquals((Object)builder.create().parse((KeyAction)Key.DOWN).name(), (Object)new NextHistory().name());
            InputrcParser.parseLine((String)"\"\\M-\\C-D\": backward-char", (EditModeBuilder)builder);
            Assert.assertEquals((Object)builder.create().parse((KeyAction)Key.META_CTRL_D).name(), (Object)new BackwardChar().name());
            InputrcParser.parseLine((String)"\"\\C-\\M-d\": backward-char", (EditModeBuilder)builder);
            Assert.assertEquals((Object)builder.create().parse((KeyAction)Key.META_CTRL_D).name(), (Object)new BackwardChar().name());
            InputrcParser.parseLine((String)"\"\\C-a\": end-of-line", (EditModeBuilder)builder);
            Assert.assertEquals((Object)builder.create().parse((KeyAction)Key.CTRL_A).name(), (Object)new EndOfLine().name());
        }
    }

    @Test
    public void testMapKeys() {
        if (Config.isOSPOSIXCompatible()) {
            EditModeBuilder builder = EditModeBuilder.builder();
            builder.addAction(InputrcParser.mapKeys((String)"M-a"), "meta");
            Assert.assertEquals((Object)builder.create().parse((KeyAction)Key.META_a).name(), (Object)new NoAction().name());
            builder = EditModeBuilder.builder();
            builder.addAction(InputrcParser.mapKeys((String)"M-[D"), "backward-char");
            Assert.assertEquals((Object)builder.create().parse((KeyAction)Key.LEFT).name(), (Object)new BackwardChar().name());
            builder = EditModeBuilder.builder();
            builder.addAction(InputrcParser.mapKeys((String)"M-[C"), "forward-char");
            Assert.assertEquals((Object)builder.create().parse((KeyAction)Key.RIGHT).name(), (Object)new ForwardChar().name());
            builder = EditModeBuilder.builder();
            builder.addAction(InputrcParser.mapKeys((String)"M-[A"), "previous-history");
            Assert.assertEquals((Object)builder.create().parse((KeyAction)Key.UP).name(), (Object)new PrevHistory().name());
            builder = EditModeBuilder.builder();
            builder.addAction(InputrcParser.mapKeys((String)"M-[B"), "next-history");
            Assert.assertEquals((Object)builder.create().parse((KeyAction)Key.DOWN).name(), (Object)new NextHistory().name());
            builder = EditModeBuilder.builder();
            builder.addAction(InputrcParser.mapKeys((String)"M-C-d"), "backward-char");
            Assert.assertEquals((Object)builder.create().parse((KeyAction)Key.META_CTRL_D).name(), (Object)new BackwardChar().name());
            builder = EditModeBuilder.builder();
            builder.addAction(InputrcParser.mapKeys((String)"C-M-D"), "forward-char");
            Assert.assertEquals((Object)builder.create().parse((KeyAction)Key.META_CTRL_D).name(), (Object)new ForwardChar().name());
            builder = EditModeBuilder.builder();
            builder.addAction(InputrcParser.mapKeys((String)"C-a"), "beginning-of-line");
            Assert.assertEquals((Object)builder.create().parse((KeyAction)Key.CTRL_A).name(), (Object)new BeginningOfLine().name());
            builder = EditModeBuilder.builder();
            builder.addAction(InputrcParser.mapKeys((String)"C-?"), "backward-delete-char");
            Assert.assertEquals((Object)builder.create().parse((KeyAction)Key.BACKSPACE).name(), (Object)new DeletePrevChar().name());
        }
    }
}

