/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.tty.terminal;

import java.nio.charset.Charset;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.function.Consumer;
import org.aesh.io.Decoder;
import org.aesh.readline.Prompt;
import org.aesh.readline.TestReadline;
import org.aesh.readline.completion.Completion;
import org.aesh.readline.editing.EditMode;
import org.aesh.readline.editing.EditModeBuilder;
import org.aesh.readline.terminal.Key;
import org.aesh.terminal.Connection;
import org.aesh.terminal.tty.Capability;
import org.aesh.terminal.tty.Signal;
import org.aesh.terminal.tty.Size;
import org.aesh.util.Parser;
import org.junit.Assert;

public class TestConnection
implements Connection {
    private final Decoder decoder;
    private Consumer<Size> sizeHandler;
    private Consumer<Signal> signalHandler;
    private Consumer<int[]> stdinHandler;
    private Consumer<int[]> stdOutHandler;
    private Consumer<Void> closeHandler;
    private StringBuilder bufferBuilder;
    private Queue<String> out;
    private TestReadline readline;
    private Size size;
    private Prompt prompt = new Prompt(": ");

    public TestConnection() {
        this(EditModeBuilder.builder().create(), null);
    }

    public TestConnection(Prompt prompt) {
        this(EditModeBuilder.builder().create(), null, prompt);
    }

    public TestConnection(EditMode editMode) {
        this(editMode, null);
    }

    public TestConnection(List<Completion> completions) {
        this(EditModeBuilder.builder().create(), completions);
    }

    public TestConnection(EditMode editMode, List<Completion> completions) {
        this(editMode, completions, null, null);
    }

    public TestConnection(EditMode editMode, List<Completion> completions, Prompt prompt) {
        this(editMode, completions, null, prompt);
    }

    public TestConnection(EditMode editMode, List<Completion> completions, Size size) {
        this(editMode, completions, size, null);
    }

    public TestConnection(EditMode editMode, List<Completion> completions, Size size, Prompt prompt) {
        this(null, editMode, completions, size, prompt);
    }

    public TestConnection(TestReadline readline, EditMode editMode, List<Completion> completions, Size size, Prompt prompt) {
        if (editMode == null) {
            editMode = EditModeBuilder.builder().create();
        }
        this.bufferBuilder = new StringBuilder();
        this.stdOutHandler = ints -> this.bufferBuilder.append(Parser.stripAwayAnsiCodes((String)Parser.fromCodePoints((int[])ints)));
        this.size = size == null ? new Size(80, 20) : size;
        if (prompt != null) {
            this.prompt = prompt;
        }
        this.decoder = new Decoder(512, Charset.defaultCharset(), this.stdinHandler);
        this.out = new LinkedList<String>();
        if (readline == null) {
            this.readline = new TestReadline(editMode);
            if (completions != null) {
                this.readline(completions);
            } else {
                this.readline();
            }
        } else {
            this.readline = readline;
        }
    }

    public void readline() {
        this.clearOutputBuffer();
        this.readline.readline(this, this.prompt, out -> this.out.add((String)out));
    }

    public void readline(Consumer<String> out) {
        this.clearOutputBuffer();
        this.readline.readline(this, this.prompt, out);
    }

    public void readline(List<Completion> completions) {
        this.clearOutputBuffer();
        this.readline.readline(this, this.prompt, out -> this.out.add((String)out), completions);
    }

    public void readline(List<Completion> completions, Consumer<String> out) {
        this.clearOutputBuffer();
        this.readline.readline(this, this.prompt, out, completions);
    }

    public void clearOutputBuffer() {
        if (this.bufferBuilder.length() > 0) {
            this.bufferBuilder.delete(0, this.bufferBuilder.length());
        }
    }

    public String getOutputBuffer() {
        return this.bufferBuilder.toString();
    }

    public String getPrompt() {
        return Parser.fromCodePoints((int[])this.prompt.getPromptAsString());
    }

    public void setPrompt(Prompt prompt) {
        if (prompt != null) {
            this.prompt = prompt;
        }
    }

    public String getLine() {
        return this.out.poll();
    }

    public String terminalType() {
        return "fooTerm";
    }

    public Size size() {
        return this.size;
    }

    public Consumer<Size> getSizeHandler() {
        return this.sizeHandler;
    }

    public void setSizeHandler(Consumer<Size> handler) {
        this.sizeHandler = handler;
    }

    public Consumer<Signal> getSignalHandler() {
        return this.signalHandler;
    }

    public void setSignalHandler(Consumer<Signal> handler) {
        this.signalHandler = handler;
    }

    public Consumer<int[]> getStdinHandler() {
        return this.stdinHandler;
    }

    public void setStdinHandler(Consumer<int[]> handler) {
        this.stdinHandler = handler;
        this.decoder.setConsumer(this.stdinHandler);
    }

    public Consumer<int[]> stdoutHandler() {
        return this.stdOutHandler;
    }

    public void setCloseHandler(Consumer<Void> closeHandler) {
        this.closeHandler = closeHandler;
    }

    public Consumer<Void> getCloseHandler() {
        return this.closeHandler;
    }

    public void close() {
        this.closeHandler.accept(null);
    }

    public void openBlocking() {
    }

    public void openNonBlocking() {
    }

    public void stopReading() {
    }

    public void suspend() {
    }

    public boolean suspended() {
        return false;
    }

    public void awake() {
    }

    public boolean put(Capability capability, Object ... params) {
        return false;
    }

    public void assertOutputBuffer(String expected) {
        Assert.assertEquals((Object)expected, (Object)this.bufferBuilder.toString());
    }

    public void assertBuffer(String expected) {
        Assert.assertEquals((Object)expected, (Object)Parser.stripAwayAnsiCodes((String)this.readline.getBuffer()));
    }

    public void assertLine(String expected) {
        Assert.assertEquals((Object)expected, (Object)this.out.poll());
    }

    public void read(int ... data) {
        this.stdinHandler.accept(data);
    }

    public void read(byte[] data) {
        this.decoder.write(data);
    }

    public void read(Key key) {
        this.stdinHandler.accept(key.getKeyValues());
    }

    public void read(String data) {
        this.stdinHandler.accept(Parser.toCodePoints((String)data));
    }
}

