/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.history;

import java.io.File;
import java.io.IOException;
import org.aesh.readline.editing.EditMode;
import org.aesh.readline.editing.EditModeBuilder;
import org.aesh.readline.history.FileHistory;
import org.aesh.readline.history.InMemoryHistory;
import org.aesh.readline.history.SearchDirection;
import org.aesh.readline.terminal.Key;
import org.aesh.readline.tty.terminal.TestConnection;
import org.aesh.util.FileAccessPermission;
import org.aesh.util.Parser;
import org.aesh.utils.Config;
import org.junit.Assert;
import org.junit.Test;

public class HistoryTest {
    @Test
    public void testHistory() throws Exception {
        TestConnection term = new TestConnection(EditModeBuilder.builder((EditMode.Mode)EditMode.Mode.EMACS).create());
        term.read("1234" + Config.getLineSeparator());
        term.readline();
        term.read("567" + Config.getLineSeparator());
        term.readline();
        term.read(Key.UP);
        term.read(Key.UP);
        term.read(Key.ENTER);
        term.assertLine("1234");
        term.readline();
        term.read(Key.UP);
        term.read(Key.UP);
        term.read(Key.ENTER);
        term.assertLine("567");
    }

    @Test
    public void testReverseSearch() throws Exception {
        TestConnection term = new TestConnection(EditModeBuilder.builder((EditMode.Mode)EditMode.Mode.EMACS).create());
        term.read("1234" + Config.getLineSeparator());
        term.readline();
        term.read("567" + Config.getLineSeparator());
        term.readline();
        term.read("589" + Config.getLineSeparator());
        term.readline();
        term.clearOutputBuffer();
        term.read(Key.CTRL_R);
        term.assertBuffer("(reverse-i-search) `': ");
        term.clearOutputBuffer();
        term.read("5");
        term.assertBuffer("(reverse-i-search) `5': 589");
        term.clearLineBuffer();
        term.read(Key.ENTER);
        term.assertLine("589");
    }

    @Test
    public void testForwardSearch() throws Exception {
        TestConnection term = new TestConnection(EditModeBuilder.builder((EditMode.Mode)EditMode.Mode.EMACS).create());
        term.read("1234" + Config.getLineSeparator());
        term.readline();
        term.read("567" + Config.getLineSeparator());
        term.readline();
        term.read("589" + Config.getLineSeparator());
        term.readline();
        term.clearOutputBuffer();
        term.read(Key.CTRL_S);
        term.assertBuffer("(forward-i-search) `': ");
        term.clearOutputBuffer();
        term.read("5");
        term.assertBuffer("(forward-i-search) `5': 567");
        term.clearLineBuffer();
        term.read(Key.ENTER);
        term.assertLine("567");
    }

    @Test
    public void testReverseSearchEscape() throws Exception {
        TestConnection term = new TestConnection(EditModeBuilder.builder((EditMode.Mode)EditMode.Mode.EMACS).create());
        term.read("1234" + Config.getLineSeparator());
        term.readline();
        term.read("567" + Config.getLineSeparator());
        term.readline();
        term.read("589" + Config.getLineSeparator());
        term.readline();
        term.clearOutputBuffer();
        term.read(Key.CTRL_R);
        term.assertBuffer("(reverse-i-search) `': ");
        term.clearOutputBuffer();
        term.read("5");
        term.assertBuffer("(reverse-i-search) `5': 589");
        term.clearLineBuffer();
        term.clearOutputBuffer();
        term.read(Key.ESC);
        term.assertBuffer("589");
        term.assertLine(null);
        term.read(Key.ENTER);
        term.assertLine("589");
    }

    @Test
    public void testSearch() {
        InMemoryHistory history = new InMemoryHistory(20);
        history.push(Parser.toCodePoints((String)"foo1"));
        history.push(Parser.toCodePoints((String)"foo2"));
        history.push(Parser.toCodePoints((String)"foo3"));
        history.setSearchDirection(SearchDirection.REVERSE);
        Assert.assertArrayEquals((int[])Parser.toCodePoints((String)"foo3"), (int[])history.search(Parser.toCodePoints((String)"foo")));
        Assert.assertArrayEquals((int[])Parser.toCodePoints((String)"foo2"), (int[])history.search(Parser.toCodePoints((String)"foo")));
        Assert.assertArrayEquals((int[])Parser.toCodePoints((String)"foo1"), (int[])history.search(Parser.toCodePoints((String)"foo")));
        history.setSearchDirection(SearchDirection.FORWARD);
        Assert.assertArrayEquals((int[])Parser.toCodePoints((String)"foo1"), (int[])history.search(Parser.toCodePoints((String)"foo")));
        Assert.assertArrayEquals((int[])Parser.toCodePoints((String)"foo2"), (int[])history.search(Parser.toCodePoints((String)"foo")));
        Assert.assertArrayEquals((int[])Parser.toCodePoints((String)"foo3"), (int[])history.search(Parser.toCodePoints((String)"foo")));
        history.setSearchDirection(SearchDirection.REVERSE);
        Assert.assertArrayEquals((int[])Parser.toCodePoints((String)"foo3"), (int[])history.search(Parser.toCodePoints((String)"foo")));
        Assert.assertArrayEquals((int[])Parser.toCodePoints((String)"foo2"), (int[])history.search(Parser.toCodePoints((String)"foo")));
        Assert.assertArrayEquals((int[])Parser.toCodePoints((String)"foo1"), (int[])history.search(Parser.toCodePoints((String)"foo")));
        history.setSearchDirection(SearchDirection.REVERSE);
        Assert.assertArrayEquals((int[])Parser.toCodePoints((String)"foo3"), (int[])history.search(Parser.toCodePoints((String)"foo")));
        Assert.assertArrayEquals((int[])Parser.toCodePoints((String)"foo2"), (int[])history.search(Parser.toCodePoints((String)"foo")));
        Assert.assertArrayEquals((int[])Parser.toCodePoints((String)"foo1"), (int[])history.search(Parser.toCodePoints((String)"foo")));
        Assert.assertArrayEquals((int[])Parser.toCodePoints((String)"foo3"), (int[])history.search(Parser.toCodePoints((String)"foo")));
    }

    @Test
    public void testSearchAndFetch() {
        InMemoryHistory history = new InMemoryHistory(20);
        history.push(Parser.toCodePoints((String)"foo1"));
        history.push(Parser.toCodePoints((String)"foo2"));
        history.push(Parser.toCodePoints((String)"foo3"));
        history.setSearchDirection(SearchDirection.REVERSE);
        Assert.assertArrayEquals((int[])Parser.toCodePoints((String)"foo3"), (int[])history.search(Parser.toCodePoints((String)"foo")));
        Assert.assertArrayEquals((int[])Parser.toCodePoints((String)"foo2"), (int[])history.getPreviousFetch());
    }

    @Test
    public void testHistorySize() {
        InMemoryHistory history = new InMemoryHistory(20);
        for (int i = 0; i < 25; ++i) {
            history.push(Parser.toCodePoints((String)String.valueOf(i)));
        }
        Assert.assertEquals((long)20L, (long)history.size());
        Assert.assertArrayEquals((int[])Parser.toCodePoints((String)"24"), (int[])history.getPreviousFetch());
    }

    @Test
    public void testClear() {
        InMemoryHistory history = new InMemoryHistory(10);
        history.push(Parser.toCodePoints((String)"1"));
        history.push(Parser.toCodePoints((String)"2"));
        Assert.assertArrayEquals((int[])Parser.toCodePoints((String)"2"), (int[])history.getPreviousFetch());
        history.clear();
        Assert.assertEquals(null, (Object)history.getPreviousFetch());
    }

    @Test
    public void testDupes() {
        InMemoryHistory history = new InMemoryHistory(10);
        history.push(Parser.toCodePoints((String)"1"));
        history.push(Parser.toCodePoints((String)"2"));
        history.push(Parser.toCodePoints((String)"3"));
        history.push(Parser.toCodePoints((String)"1"));
        history.push(Parser.toCodePoints((String)"1"));
        Assert.assertArrayEquals((int[])Parser.toCodePoints((String)"1"), (int[])history.getPreviousFetch());
        Assert.assertArrayEquals((int[])Parser.toCodePoints((String)"3"), (int[])history.getPreviousFetch());
        Assert.assertArrayEquals((int[])Parser.toCodePoints((String)"1"), (int[])history.getNextFetch());
        Assert.assertArrayEquals((int[])Parser.toCodePoints((String)"3"), (int[])history.getPreviousFetch());
        Assert.assertArrayEquals((int[])Parser.toCodePoints((String)"2"), (int[])history.getPreviousFetch());
        Assert.assertArrayEquals((int[])Parser.toCodePoints((String)"1"), (int[])history.getPreviousFetch());
        Assert.assertEquals((long)4L, (long)history.getAll().size());
    }

    @Test
    public void testFileHistoryPermission() throws IOException {
        if (Config.isOSPOSIXCompatible()) {
            File historyFile = new File(System.getProperty("java.io.tmpdir"), "aesh-history-file.test.1");
            historyFile.deleteOnExit();
            int maxSize = 10;
            FileAccessPermission perm = new FileAccessPermission();
            perm.setExecutable(false);
            perm.setExecutableOwnerOnly(false);
            perm.setReadable(true);
            perm.setReadableOwnerOnly(true);
            perm.setWritable(true);
            perm.setWritableOwnerOnly(true);
            FileHistory history = new FileHistory(historyFile, maxSize, perm, false);
            history.push(Parser.toCodePoints((String)"1"));
            history.stop();
            Assert.assertTrue((boolean)historyFile.canRead());
            Assert.assertFalse((boolean)historyFile.canExecute());
            Assert.assertTrue((boolean)historyFile.canWrite());
            historyFile = new File(System.getProperty("java.io.tmpdir"), "aesh-history-file.test.2");
            historyFile.deleteOnExit();
            perm = new FileAccessPermission();
            perm.setExecutable(true);
            perm.setExecutableOwnerOnly(true);
            perm.setReadable(false);
            perm.setReadableOwnerOnly(true);
            perm.setWritable(true);
            perm.setWritableOwnerOnly(true);
            history = new FileHistory(historyFile, maxSize, perm, false);
            history.push(Parser.toCodePoints((String)"1"));
            history.stop();
            Assert.assertFalse((boolean)historyFile.canRead());
            Assert.assertTrue((boolean)historyFile.canExecute());
            Assert.assertTrue((boolean)historyFile.canWrite());
            historyFile = new File(System.getProperty("java.io.tmpdir"), "aesh-history-file.test.3");
            historyFile.deleteOnExit();
            perm = new FileAccessPermission();
            perm.setExecutable(false);
            perm.setExecutableOwnerOnly(true);
            perm.setReadable(false);
            perm.setReadableOwnerOnly(true);
            perm.setWritable(false);
            perm.setWritableOwnerOnly(true);
            history = new FileHistory(historyFile, maxSize, perm, false);
            history.push(Parser.toCodePoints((String)"1"));
            history.stop();
            Assert.assertFalse((boolean)historyFile.canRead());
            Assert.assertFalse((boolean)historyFile.canExecute());
            Assert.assertFalse((boolean)historyFile.canWrite());
        }
    }

    @Test
    public void testPrevHistory() {
        InMemoryHistory history = new InMemoryHistory(20);
        history.push(Parser.toCodePoints((String)"foo1"));
        history.push(Parser.toCodePoints((String)"foo2"));
        history.push(Parser.toCodePoints((String)"foo3"));
        Assert.assertArrayEquals((int[])Parser.toCodePoints((String)"foo3"), (int[])history.getPreviousFetch());
        history.push(Parser.toCodePoints((String)"foo3"));
        Assert.assertArrayEquals((int[])Parser.toCodePoints((String)"foo3"), (int[])history.getPreviousFetch());
    }
}

