/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.tty.terminal;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.nio.charset.Charset;
import java.util.ArrayList;
import org.aesh.readline.Prompt;
import org.aesh.readline.Readline;
import org.aesh.readline.TestTerminal;
import org.aesh.readline.tty.terminal.TerminalConnection;
import org.aesh.readline.tty.terminal.TestConnection;
import org.aesh.terminal.Attributes;
import org.aesh.terminal.Connection;
import org.aesh.terminal.tty.Signal;
import org.aesh.utils.Config;
import org.junit.Assert;
import org.junit.Test;

public class TestTerminalConnection {
    @Test
    public void testRead() throws IOException, InterruptedException {
        PipedOutputStream outputStream = new PipedOutputStream();
        PipedInputStream pipedInputStream = new PipedInputStream(outputStream);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TerminalConnection connection = new TerminalConnection(Charset.defaultCharset(), (InputStream)pipedInputStream, (OutputStream)byteArrayOutputStream);
        ArrayList result = new ArrayList();
        connection.setStdinHandler(result::add);
        outputStream.write("FOO".getBytes());
        outputStream.flush();
        outputStream.close();
        Thread.sleep(150L);
        connection.openBlocking();
        Assert.assertArrayEquals((int[])((int[])result.get(0)), (int[])new int[]{70, 79, 79});
    }

    @Test
    public void testTestConnection() {
        TestTerminal testConnection = new TestTerminal();
        testConnection.read(read -> Assert.assertEquals((Object)"foo", (Object)read));
        testConnection.write("foo\n");
        testConnection.close();
        testConnection.start();
    }

    @Test
    public void testConnection() {
        TestConnection test = new TestConnection();
        test.read("foo");
        test.assertBuffer("foo");
        test.assertLine(null);
        test.read("\n");
        test.assertLine("foo");
    }

    @Test
    public void testSignal() throws IOException, InterruptedException {
        PipedOutputStream outputStream = new PipedOutputStream();
        PipedInputStream pipedInputStream = new PipedInputStream(outputStream);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TerminalConnection connection = new TerminalConnection(Charset.defaultCharset(), (InputStream)pipedInputStream, (OutputStream)out);
        Attributes attributes = new Attributes();
        attributes.setLocalFlag(Attributes.LocalFlag.ECHOCTL, true);
        connection.setAttributes(attributes);
        Readline readline = new Readline();
        readline.readline((Connection)connection, new Prompt(""), s -> {});
        connection.openNonBlocking();
        outputStream.write("FOO".getBytes());
        outputStream.flush();
        Thread.sleep(100L);
        connection.getTerminal().raise(Signal.INT);
        connection.close();
        Assert.assertEquals((Object)("FOO^C" + Config.getLineSeparator()), (Object)new String(out.toByteArray()));
    }

    @Test
    public void testSignalEchoCtlFalse() throws IOException, InterruptedException {
        PipedOutputStream outputStream = new PipedOutputStream();
        PipedInputStream pipedInputStream = new PipedInputStream(outputStream);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TerminalConnection connection = new TerminalConnection(Charset.defaultCharset(), (InputStream)pipedInputStream, (OutputStream)out);
        Readline readline = new Readline();
        readline.readline((Connection)connection, new Prompt(""), s -> {});
        connection.openNonBlocking();
        outputStream.write("FOO".getBytes());
        outputStream.flush();
        Thread.sleep(100L);
        connection.getTerminal().raise(Signal.INT);
        connection.close();
        Assert.assertEquals((Object)new String(out.toByteArray()), (Object)("FOO" + Config.getLineSeparator()));
    }

    @Test
    public void testCustomSignal() throws IOException, InterruptedException {
        PipedOutputStream outputStream = new PipedOutputStream();
        PipedInputStream pipedInputStream = new PipedInputStream(outputStream);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        TerminalConnection connection = new TerminalConnection(Charset.defaultCharset(), (InputStream)pipedInputStream, (OutputStream)out);
        connection.setSignalHandler(signal -> {
            if (signal == Signal.INT) {
                connection.write("BAR");
                connection.stdoutHandler().accept(Config.CR);
                connection.close();
            }
        });
        Readline readline = new Readline();
        readline.readline((Connection)connection, new Prompt(""), s -> {});
        connection.openNonBlocking();
        outputStream.write(("GAH" + Config.getLineSeparator()).getBytes());
        outputStream.flush();
        Thread.sleep(250L);
        Assert.assertEquals((Object)new String(out.toByteArray()), (Object)("GAH" + Config.getLineSeparator()));
        readline.readline((Connection)connection, new Prompt(""), s -> {});
        outputStream.write("FOO".getBytes());
        outputStream.flush();
        connection.getTerminal().raise(Signal.INT);
        Thread.sleep(250L);
        Assert.assertEquals((Object)new String(out.toByteArray()), (Object)("GAH" + Config.getLineSeparator() + "FOOBAR" + Config.getLineSeparator()));
    }
}

