/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline.terminal;

import org.aesh.readline.terminal.Key;
import org.aesh.readline.tty.terminal.TestConnection;
import org.aesh.terminal.Attributes;
import org.aesh.terminal.tty.Signal;
import org.junit.Assert;
import org.junit.Test;

public class SignalTest {
    @Test
    public void testSignals() {
        TestConnection connection = new TestConnection(null, null, null, null, null, null, null);
        connection.setSignalHandler(signal -> {
            if (signal == Signal.INT) {
                connection.write("INTR");
            } else if (signal == Signal.EOF) {
                connection.write("EOF");
            }
        });
        connection.read("foo");
        Assert.assertEquals((Object)": foo", (Object)connection.getOutputBuffer());
        connection.read(Key.CTRL_D);
        Assert.assertEquals((Object)": fooEOF", (Object)connection.getOutputBuffer());
    }

    @Test
    public void testCustomSignals() {
        Attributes attributes = new Attributes();
        attributes.setControlChar(Attributes.ControlChar.VEOF, Key.CTRL_A.getFirstValue());
        attributes.setControlChar(Attributes.ControlChar.VINTR, Key.CTRL_B.getFirstValue());
        TestConnection connection = new TestConnection(null, null, null, null, null, attributes, null);
        connection.setSignalHandler(signal -> {
            if (signal == Signal.INT) {
                connection.write("INTR");
            } else if (signal == Signal.EOF) {
                connection.write("EOF");
            }
        });
        connection.read("foo");
        Assert.assertEquals((Object)": foo", (Object)connection.getOutputBuffer());
        connection.read(Key.CTRL_B);
        Assert.assertEquals((Object)": fooINTR", (Object)connection.getOutputBuffer());
        connection.read(Key.CTRL_A);
        Assert.assertEquals((Object)": fooINTREOF", (Object)connection.getOutputBuffer());
    }
}

