/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline;

import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.aesh.readline.example.SimpleTestExample;
import org.aesh.util.LoggerUtil;
import org.aesh.utils.Config;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.exporter.ZipExporter;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.resolver.api.maven.archive.importer.MavenImporter;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Before;
import org.junit.Test;

public class TestReadlineInSeparateProcess {
    private static final Logger LOGGER = LoggerUtil.getLogger((String)TestReadlineInSeparateProcess.class.getName());
    private static final String EMBED_SERVER = "embed-server";
    private static final int TIMEOUT = Integer.getInteger("start.timeout", 30);
    private static final String EMBED_SERVER_PROMPT = "embed-server" + Config.getLineSeparator() + "=====> embed-server" + Config.getLineSeparator();
    private CharPumper outPump;
    private BufferedWriter writer;

    @Before
    public void posixOnly() {
        Assume.assumeTrue((boolean)Config.isOSPOSIXCompatible());
    }

    private void sendLine(String line) {
        try {
            Thread.sleep(50L);
            this.outPump.clearOutput();
            Thread.sleep(50L);
            this.writer.write(line);
            this.writer.write(Config.getLineSeparator());
            this.writer.flush();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private String waitFor(String expected, String errorMessage) {
        boolean found = false;
        for (int i = 0; i < TIMEOUT * 100; ++i) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this.outPump.getOutput().contains(expected)) continue;
            found = true;
            break;
        }
        String out = this.outPump.clearOutput();
        Assert.assertEquals((Object)expected, (Object)out);
        if (!found) {
            throw new RuntimeException(String.format("%s\nFailed to found expected <%s> in following output:\n%s", errorMessage, expected, out));
        }
        return out;
    }

    @Test
    public void startProcessClassPath() throws Exception {
        String java = System.getProperty("java.home") + Config.getPathSeparator() + "bin" + Config.getPathSeparator() + "java";
        String classpath = Arrays.stream(((URLClassLoader)Thread.currentThread().getContextClassLoader()).getURLs()).map(URL::getFile).collect(Collectors.joining(File.pathSeparator));
        ProcessBuilder pb = new ProcessBuilder(java, "-classpath", classpath, SimpleTestExample.class.getCanonicalName());
        this.testReadlineByProcessBuilder(pb);
    }

    @Test
    public void startProcessJar() throws Exception {
        String jarName = String.format("target%stest.jar", File.separator);
        String java = System.getProperty("java.home") + Config.getPathSeparator() + "bin" + Config.getPathSeparator() + "java";
        JavaArchive archive = (JavaArchive)((MavenImporter)ShrinkWrap.create(MavenImporter.class)).loadPomFromFile("pom.xml").importBuildOutput().importBuildOutput().as(JavaArchive.class);
        archive.addAsManifestResource((Asset)new StringAsset(String.format("Manifest-Version: 1.0\nMain-Class: %s\n", SimpleTestExample.class.getCanonicalName())), "MANIFEST.MF");
        archive.addClass(SimpleTestExample.class);
        File fileArchive = new File(jarName);
        ((ZipExporter)archive.as(ZipExporter.class)).exportTo(fileArchive, true);
        ProcessBuilder pb = new ProcessBuilder(java, "-jar", jarName);
        this.testReadlineByProcessBuilder(pb);
    }

    private void testReadlineByProcessBuilder(ProcessBuilder pb) throws Exception {
        pb.redirectErrorStream(true);
        Process process = pb.start();
        Thread.sleep(200L);
        InputStreamReader isr = new InputStreamReader(process.getInputStream());
        this.outPump = new CharPumper(isr);
        this.outPump.start();
        this.writer = new BufferedWriter(new OutputStreamWriter(process.getOutputStream()));
        this.sendLine(EMBED_SERVER);
        this.waitFor(EMBED_SERVER_PROMPT, "Failed to start the embedded EAP instance.");
        this.sendLine("exit");
    }

    private class CharPumper
    extends Thread {
        private final InputStreamReader inputReader;
        private final StringBuffer output;

        CharPumper(InputStreamReader outputReader) {
            this.inputReader = outputReader;
            this.output = new StringBuffer();
        }

        @Override
        public void run() {
            try {
                int c;
                while ((c = this.inputReader.read()) != -1) {
                    this.append((char)c);
                }
            }
            catch (IOException iOException) {
            }
            finally {
                try {
                    if (this.inputReader != null) {
                        this.inputReader.close();
                    }
                }
                catch (IOException iOException) {}
            }
        }

        private synchronized void append(char c) {
            this.output.append(c);
        }

        private synchronized String getOutput() {
            return this.output.toString();
        }

        private synchronized String clearOutput() {
            String out = this.output.toString();
            this.output.setLength(0);
            return out;
        }
    }
}

