/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.readline;

import java.util.EnumMap;
import org.aesh.readline.ReadlineFlag;
import org.aesh.readline.terminal.Key;
import org.aesh.readline.tty.terminal.TestConnection;
import org.junit.Assert;
import org.junit.Test;

public class EOFTest {
    @Test
    public void testEOF() {
        int[] closeCalled = new int[]{0};
        EnumMap<ReadlineFlag, Integer> flags = new EnumMap<ReadlineFlag, Integer>(ReadlineFlag.class);
        TestConnection term = new TestConnection(flags);
        term.setCloseHandler(v -> {
            closeCalled[0] = closeCalled[0] + 1;
        });
        term.read("foo".getBytes());
        term.read(Key.CTRL_D);
        term.assertBuffer("foo");
        term.read(Key.CTRL_A);
        term.read(Key.CTRL_D);
        term.assertBuffer("oo");
        term.read(Key.CTRL_D);
        term.read(Key.CTRL_D);
        Assert.assertEquals((long)0L, (long)closeCalled[0]);
        term.read(Key.CTRL_D);
        Assert.assertEquals((long)1L, (long)closeCalled[0]);
    }

    @Test
    public void testIgnoreEOF() {
        int[] closeCalled = new int[]{0};
        EnumMap<ReadlineFlag, Integer> flags = new EnumMap<ReadlineFlag, Integer>(ReadlineFlag.class);
        flags.put(ReadlineFlag.IGNORE_EOF, 2);
        TestConnection term = new TestConnection(flags);
        term.setCloseHandler(v -> {
            closeCalled[0] = closeCalled[0] + 1;
        });
        term.read("foo".getBytes());
        term.read(Key.CTRL_D);
        term.assertBuffer("foo");
        term.read(Key.CTRL_A);
        term.read(Key.CTRL_D);
        term.assertBuffer("oo");
        term.read(Key.CTRL_D);
        term.read(Key.CTRL_D);
        Assert.assertEquals((long)0L, (long)closeCalled[0]);
        term.read(Key.CTRL_D);
        Assert.assertEquals((long)0L, (long)closeCalled[0]);
        term.read(Key.CTRL_D);
        Assert.assertEquals((long)0L, (long)closeCalled[0]);
        term.read(Key.CTRL_D);
        Assert.assertEquals((long)1L, (long)closeCalled[0]);
    }

    @Test
    public void testIgnoreEOF2() {
        int[] closeCalled = new int[]{0};
        EnumMap<ReadlineFlag, Integer> flags = new EnumMap<ReadlineFlag, Integer>(ReadlineFlag.class);
        flags.put(ReadlineFlag.IGNORE_EOF, 2);
        TestConnection term = new TestConnection(flags);
        term.setCloseHandler(v -> {
            closeCalled[0] = closeCalled[0] + 1;
        });
        term.read("foo".getBytes());
        term.read(Key.CTRL_D);
        term.assertBuffer("foo");
        term.read(Key.CTRL_A);
        term.read(Key.CTRL_D);
        term.assertBuffer("oo");
        term.read(Key.CTRL_D);
        term.read(Key.CTRL_D);
        Assert.assertEquals((long)0L, (long)closeCalled[0]);
        term.read(Key.CTRL_D);
        Assert.assertEquals((long)0L, (long)closeCalled[0]);
        term.read(Key.CTRL_D);
        term.read(Key.CTRL_A);
        Assert.assertEquals((long)0L, (long)closeCalled[0]);
        term.read(Key.CTRL_D);
        Assert.assertEquals((long)0L, (long)closeCalled[0]);
        term.read(Key.CTRL_D);
        term.read(Key.CTRL_D);
        Assert.assertEquals((long)1L, (long)closeCalled[0]);
    }
}

