/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.http.netty;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.group.ChannelGroup;
import io.netty.channel.group.DefaultChannelGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.EventExecutor;
import io.netty.util.concurrent.ImmediateEventExecutor;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.aesh.terminal.Connection;
import org.aesh.terminal.http.netty.TtyServerInitializer;

public class NettyWebsocketTtyBootstrap {
    private final ChannelGroup channelGroup = new DefaultChannelGroup((EventExecutor)ImmediateEventExecutor.INSTANCE);
    private String host = "localhost";
    private int port = 8080;
    private EventLoopGroup group;
    private Channel channel;

    public String getHost() {
        return this.host;
    }

    public NettyWebsocketTtyBootstrap setHost(String host) {
        this.host = host;
        return this;
    }

    public int getPort() {
        return this.port;
    }

    public NettyWebsocketTtyBootstrap setPort(int port) {
        this.port = port;
        return this;
    }

    public void start(Consumer<Connection> handler, Consumer<Throwable> doneHandler) {
        this.group = new NioEventLoopGroup();
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)b.group(this.group).channel(NioServerSocketChannel.class)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new TtyServerInitializer(this.channelGroup, handler));
        ChannelFuture f = b.bind(this.host, this.port);
        f.addListener(abc -> {
            if (abc.isSuccess()) {
                this.channel = f.channel();
                doneHandler.accept(null);
            } else {
                doneHandler.accept(abc.cause());
            }
        });
    }

    public CompletableFuture<Void> start(Consumer<Connection> handler) throws Exception {
        CompletableFuture<Void> fut = new CompletableFuture<Void>();
        this.start(handler, this.startedHandler(fut));
        return fut;
    }

    public void stop(Consumer<Throwable> doneHandler) {
        if (this.channel != null) {
            this.channel.close();
        }
        this.channelGroup.close().addListener(f -> doneHandler.accept(f.cause()));
    }

    public CompletableFuture<Void> stop() throws InterruptedException {
        CompletableFuture<Void> fut = new CompletableFuture<Void>();
        this.stop(this.stoppedHandler(fut));
        return fut;
    }

    private Consumer<Throwable> startedHandler(CompletableFuture<?> fut) {
        return err -> {
            if (err == null) {
                fut.complete(null);
            } else {
                fut.completeExceptionally((Throwable)err);
            }
        };
    }

    private Consumer<Throwable> stoppedHandler(CompletableFuture<?> fut) {
        return err -> fut.complete(null);
    }
}

