/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.telnet;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class TelnetCharset
extends Charset {
    public static final Charset INSTANCE = new TelnetCharset();

    private TelnetCharset() {
        super("Telnet", new String[0]);
    }

    @Override
    public boolean contains(Charset cs) {
        return cs.name().equals(this.name());
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new CharsetDecoder(this, 1.0f, 1.0f){
            private boolean prevCR;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
                int pos = in.position();
                int limit = in.limit();
                try {
                    while (pos < limit) {
                        char c;
                        byte b = in.get(pos);
                        if (b >= 0) {
                            if (this.prevCR && (b == 10 || b == 0)) {
                                ++pos;
                                this.prevCR = false;
                                continue;
                            }
                            c = (char)b;
                            this.prevCR = b == 13;
                        } else {
                            c = (char)(256 + b);
                        }
                        if (out.position() >= out.limit()) {
                            CoderResult coderResult = CoderResult.OVERFLOW;
                            return coderResult;
                        }
                        ++pos;
                        out.put(c);
                    }
                    CoderResult coderResult = CoderResult.UNDERFLOW;
                    return coderResult;
                }
                finally {
                    in.position(pos);
                }
            }
        };
    }

    @Override
    public CharsetEncoder newEncoder() {
        throw new UnsupportedOperationException();
    }
}

