/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.telnet;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.util.concurrent.Future;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.Supplier;
import org.aesh.terminal.TestBase;
import org.aesh.terminal.telnet.TelnetHandler;
import org.aesh.terminal.telnet.netty.TelnetChannelHandler;
import org.junit.rules.ExternalResource;

public class TelnetServerRule
extends ExternalResource {
    public static final Function<Supplier<TelnetHandler>, Closeable> NETTY_SERVER = handlerFactory -> {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup(1);
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        ServerBootstrap b = new ServerBootstrap();
        ((ServerBootstrap)((ServerBootstrap)((ServerBootstrap)b.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class)).option(ChannelOption.SO_BACKLOG, (Object)100)).handler((ChannelHandler)new LoggingHandler(LogLevel.INFO))).childHandler((ChannelHandler)new ChannelInitializer<SocketChannel>(){

            public void initChannel(SocketChannel ch) throws Exception {
                ChannelPipeline p = ch.pipeline();
                TelnetChannelHandler handler = new TelnetChannelHandler(handlerFactory);
                p.addLast(new ChannelHandler[]{handler});
            }
        });
        try {
            b.bind("localhost", 4000).sync();
            return () -> TelnetServerRule.lambda$null$0((EventLoopGroup)bossGroup);
        }
        catch (InterruptedException e) {
            throw TestBase.failure((Throwable)e);
        }
    };
    private final Function<Supplier<TelnetHandler>, Closeable> serverFactory;
    protected Closeable server;

    public TelnetServerRule(Function<Supplier<TelnetHandler>, Closeable> serverFactory) {
        this.serverFactory = serverFactory;
    }

    protected void after() {
        if (this.server != null) {
            try {
                this.server.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public final void start(Supplier<TelnetHandler> telnetFactory) {
        if (this.server != null) {
            throw TestBase.failure((String)"Already a server");
        }
        this.server = this.serverFactory.apply(telnetFactory);
    }

    private static /* synthetic */ void lambda$null$0(EventLoopGroup bossGroup) throws IOException {
        Future future = bossGroup.shutdownGracefully();
        try {
            if (!future.await(30L, TimeUnit.SECONDS)) {
                throw TestBase.failure((String)"bossGroup not finished in timeout");
            }
        }
        catch (InterruptedException e) {
            throw TestBase.failure((Throwable)e);
        }
    }
}

