/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.telnet;

import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Executor;
import org.aesh.terminal.TestBase;
import org.aesh.terminal.telnet.ReadBuffer;
import org.junit.Before;
import org.junit.Test;

public class ReadBufferTest
extends TestBase {
    private ArrayBlockingQueue<Runnable> commands;
    private ReadBuffer buf;
    private ArrayList<int[]> reads;

    @Before
    public void setUp() {
        this.commands = new ArrayBlockingQueue(1);
        this.buf = new ReadBuffer(new Executor(){

            @Override
            public void execute(Runnable command) {
                ReadBufferTest.this.commands.add(command);
            }
        });
        this.reads = new ArrayList();
    }

    @Test
    public void testFoo() {
        ArrayList reads = new ArrayList();
        this.buf.setReadHandler(event -> reads.add(event));
        this.buf.accept(new int[]{102, 111, 111});
        this.assertEquals(0, this.commands.size());
        this.assertEquals(1, reads.size());
        this.assertEquals((int[])reads.get(0), new int[]{102, 111, 111});
    }

    @Test
    public void testBar() throws Exception {
        this.buf.accept(new int[]{102, 111, 111});
        this.assertEquals(0, this.reads.size());
        this.assertEquals(0, this.commands.size());
        this.buf.setReadHandler(event -> this.reads.add((int[])event));
        this.assertEquals(0, this.reads.size());
        this.assertEquals(1, this.commands.size());
        this.commands.poll().run();
        this.assertEquals(1, this.reads.size());
        this.assertEquals(0, this.commands.size());
        this.assertEquals(this.reads.get(0), new int[]{102, 111, 111});
    }

    @Test
    public void testJuu() throws Exception {
        this.buf.accept(new int[]{102, 111, 111});
        this.buf.accept(new int[]{98, 97, 114});
        this.assertEquals(0, this.reads.size());
        this.assertEquals(0, this.commands.size());
        this.buf.setReadHandler(event -> {
            this.reads.add((int[])event);
            this.buf.setReadHandler(null);
        });
        this.assertEquals(0, this.reads.size());
        this.assertEquals(1, this.commands.size());
        this.commands.poll().run();
        this.assertEquals(1, this.reads.size());
        this.assertEquals(0, this.commands.size());
        this.assertEquals(this.reads.get(0), new int[]{102, 111, 111});
        this.assertEquals(null, this.buf.getReadHandler());
    }

    @Test
    public void testBilto() throws Exception {
        this.buf.accept(new int[]{102, 111, 111});
        this.buf.accept(new int[]{98, 97, 114});
        this.assertEquals(0, this.reads.size());
        this.assertEquals(0, this.commands.size());
        this.buf.setReadHandler(event -> this.reads.add((int[])event));
        this.assertEquals(0, this.reads.size());
        this.assertEquals(1, this.commands.size());
        this.commands.poll().run();
        this.assertEquals(1, this.reads.size());
        this.assertEquals(1, this.commands.size());
        this.assertEquals(this.reads.get(0), new int[]{102, 111, 111});
        this.buf.accept(new int[]{106, 117, 117});
        this.assertEquals(3, this.reads.size());
        this.assertEquals(1, this.commands.size());
        this.assertEquals(this.reads.get(1), new int[]{98, 97, 114});
        this.assertEquals(this.reads.get(2), new int[]{106, 117, 117});
        this.commands.poll().run();
        this.assertEquals(3, this.reads.size());
        this.assertEquals(0, this.commands.size());
    }
}

