/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.extensions.less;

import java.io.File;
import java.io.IOException;
import org.aesh.extensions.manual.TerminalPage;
import org.aesh.extensions.manual.page.FileDisplayer;
import org.aesh.extensions.util.FileParser;
import org.aesh.extensions.util.SimpleFileParser;
import org.aesh.readline.completion.CompleteOperation;
import org.aesh.readline.util.Parser;
import org.aesh.terminal.Connection;
import org.aesh.utils.ANSI;

public class Less
extends FileDisplayer {
    private SimpleFileParser loader;

    public Less(Connection connection) {
        this.setConnection(connection);
        this.loader = new SimpleFileParser();
    }

    public void setFile(File file) throws IOException {
        this.loader.setFile(file);
    }

    public void setFile(String filename) throws IOException {
        this.loader.setFile(filename);
    }

    public void setInput(String input) throws IOException {
        this.loader.readPageAsString(input);
    }

    @Override
    public FileParser getFileParser() {
        return this.loader;
    }

    public void complete(CompleteOperation completeOperation) {
        if ("less".startsWith(completeOperation.getBuffer())) {
            completeOperation.addCompletionCandidate("less");
        } else if (completeOperation.getBuffer().startsWith("less ")) {
            String word = Parser.findWordClosestToCursor((String)completeOperation.getBuffer(), (int)completeOperation.getCursor());
            completeOperation.setOffset(completeOperation.getCursor());
        }
    }

    @Override
    public void displayBottom() throws IOException {
        if (this.getSearchStatus() == TerminalPage.Search.SEARCHING) {
            this.clearBottomLine();
            this.writeToConsole("/" + this.getSearchWord());
        } else if (this.getSearchStatus() == TerminalPage.Search.NOT_FOUND) {
            this.clearBottomLine();
            this.writeToConsole(ANSI.INVERT_BACKGROUND + "Pattern not found (press RETURN)" + "\u001b[0;39m");
        } else if (this.getSearchStatus() == TerminalPage.Search.RESULT) {
            this.writeToConsole(":");
        } else if (this.getSearchStatus() == TerminalPage.Search.NO_SEARCH) {
            if (this.isAtBottom()) {
                this.writeToConsole(ANSI.INVERT_BACKGROUND + "(END)" + "\u001b[0;39m");
            } else {
                this.writeToConsole(":");
            }
        }
    }
}

