/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.extensions.more;

import java.io.File;
import java.io.IOException;
import org.aesh.extensions.manual.TerminalPage;
import org.aesh.extensions.util.FileParser;
import org.aesh.extensions.util.SimpleFileParser;
import org.aesh.readline.action.KeyAction;
import org.aesh.readline.completion.CompleteOperation;
import org.aesh.readline.completion.Completion;
import org.aesh.readline.terminal.Key;
import org.aesh.readline.terminal.formatting.TerminalString;
import org.aesh.readline.util.Parser;
import org.aesh.terminal.Connection;
import org.aesh.utils.ANSI;
import org.aesh.utils.Config;

public class More
implements Completion {
    private int rows;
    private int topVisibleRow;
    private int prevTopVisibleRow;
    private StringBuilder number;
    private MorePage page;
    private SimpleFileParser loader;
    private Connection connection;

    public More(Connection connection) {
        this.connection = connection;
    }

    public void setFile(File page) throws IOException {
        this.loader.setFile(page);
    }

    public void setFile(String filename) throws IOException {
        this.loader.setFile(new File(filename));
    }

    public void setInput(String input) throws IOException {
        this.loader.readPageAsString(input);
    }

    public void afterAttach() throws IOException {
        this.loader = new SimpleFileParser();
        this.number = new StringBuilder();
        this.rows = this.connection.size().getHeight();
        int columns = this.connection.size().getWidth();
        this.page = new MorePage(this.loader, columns);
        if (this.page.hasData()) {
            this.display(Background.INVERSE);
        }
    }

    protected void afterDetach() throws IOException {
        this.clearNumber();
        this.prevTopVisibleRow = 0;
        this.topVisibleRow = 0;
        this.connection.stdoutHandler().accept(ANSI.printAnsi((String)"K"));
        this.connection.stdoutHandler().accept(ANSI.printAnsi((String)"1G"));
        this.page.clear();
    }

    public void processOperation(KeyAction operation) throws IOException {
        if (operation.getCodePointAt(0) == 113) {
            this.afterDetach();
        } else if (Key.ENTER.equalTo(operation)) {
            this.topVisibleRow += this.getNumber();
            if (this.topVisibleRow > this.page.size() - this.rows) {
                this.topVisibleRow = this.page.size() - this.rows;
                if (this.topVisibleRow < 0) {
                    this.topVisibleRow = 0;
                }
                this.display(Background.INVERSE);
                this.afterDetach();
            } else {
                this.display(Background.INVERSE);
            }
            this.clearNumber();
        } else if (operation.getCodePointAt(0) == 6 || operation.getCodePointAt(0) == 32) {
            this.topVisibleRow += this.rows * this.getNumber();
            if (this.topVisibleRow > this.page.size() - this.rows) {
                this.topVisibleRow = this.page.size() - this.rows;
                if (this.topVisibleRow < 0) {
                    this.topVisibleRow = 0;
                }
                this.display(Background.INVERSE);
                this.afterDetach();
            } else {
                this.display(Background.INVERSE);
            }
            this.clearNumber();
        } else if (operation.getCodePointAt(0) == 2) {
            this.topVisibleRow -= this.rows * this.getNumber();
            if (this.topVisibleRow < 0) {
                this.topVisibleRow = 0;
            }
            this.display(Background.INVERSE);
            this.clearNumber();
        } else if (Character.isDigit(operation.getCodePointAt(0))) {
            this.number.append(Character.getNumericValue(operation.getCodePointAt(0)));
        }
    }

    private void display(Background background) throws IOException {
        this.connection.stdoutHandler().accept(ANSI.printAnsi((String)"0G"));
        this.connection.stdoutHandler().accept(ANSI.printAnsi((String)"2K"));
        if (this.prevTopVisibleRow == 0 && this.topVisibleRow == 0) {
            for (int i = this.topVisibleRow; i < this.topVisibleRow + this.rows; ++i) {
                if (i >= this.page.size()) continue;
                this.connection.write(this.page.getLine(i));
                this.connection.write(Config.getLineSeparator());
            }
        } else if (this.prevTopVisibleRow < this.topVisibleRow) {
            for (int i = this.prevTopVisibleRow; i < this.topVisibleRow; ++i) {
                this.connection.write(this.page.getLine(i + this.rows));
                this.connection.write(Config.getLineSeparator());
            }
            this.prevTopVisibleRow = this.topVisibleRow;
        } else if (this.prevTopVisibleRow > this.topVisibleRow) {
            for (int i = this.topVisibleRow; i < this.topVisibleRow + this.rows; ++i) {
                if (i >= this.page.size()) continue;
                this.connection.write(this.page.getLine(i));
                this.connection.write(Config.getLineSeparator());
            }
            this.prevTopVisibleRow = this.topVisibleRow;
        }
        this.displayBottom(background);
    }

    private void displayBottom(Background background) throws IOException {
        if (background == Background.INVERSE) {
            this.connection.write(ANSI.INVERT_BACKGROUND);
            this.connection.write("--More--(");
            this.connection.write(this.getPercentDisplayed() + "%)");
            this.connection.write(ANSI.NORMAL_BACKGROUND);
        }
    }

    private String getPercentDisplayed() {
        double row = this.topVisibleRow + this.rows;
        if (row > (double)this.page.size()) {
            row = this.page.size();
        }
        return String.valueOf((int)(row / (double)this.page.size() * 100.0));
    }

    public void complete(CompleteOperation completeOperation) {
        if (completeOperation.getBuffer().equals("")) {
            completeOperation.getCompletionCandidates().add(new TerminalString("more"));
        } else if (completeOperation.getBuffer().equals("m")) {
            completeOperation.getCompletionCandidates().add(new TerminalString("more"));
        } else if (completeOperation.getBuffer().equals("mo")) {
            completeOperation.getCompletionCandidates().add(new TerminalString("more"));
        } else if (completeOperation.getBuffer().equals("mor")) {
            completeOperation.getCompletionCandidates().add(new TerminalString("more"));
        } else if (completeOperation.getBuffer().equals("more")) {
            completeOperation.getCompletionCandidates().add(new TerminalString("more"));
        } else if (completeOperation.getBuffer().startsWith("more ")) {
            String word = Parser.findWordClosestToCursor((String)completeOperation.getBuffer(), (int)completeOperation.getCursor());
            completeOperation.setOffset(completeOperation.getCursor());
        }
    }

    public void displayHelp() throws IOException {
        this.connection.write(Config.getLineSeparator() + "Usage: more [options] file..." + Config.getLineSeparator());
    }

    private int getNumber() {
        if (this.number.length() > 0) {
            return Integer.parseInt(this.number.toString());
        }
        return 1;
    }

    private void clearNumber() {
        this.number = new StringBuilder();
    }

    private class MorePage
    extends TerminalPage {
        public MorePage(FileParser fileParser, int columns) throws IOException {
            super(fileParser, columns);
        }
    }

    private static enum Background {
        NORMAL,
        INVERSE;

    }
}

