/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.extensions.manual;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import org.aesh.extensions.manual.ManPage;
import org.aesh.extensions.manual.page.FileDisplayer;
import org.aesh.extensions.util.FileParser;
import org.aesh.extensions.util.SimpleFileParser;
import org.aesh.readline.completion.CompleteOperation;
import org.aesh.readline.terminal.formatting.TerminalString;
import org.aesh.terminal.Connection;
import org.aesh.utils.ANSI;

public class Man
extends FileDisplayer {
    private List<ManPage> manPages = new ArrayList<ManPage>();
    private SimpleFileParser loader;

    public Man(Connection connection) {
        this.setConnection(connection);
        this.manPages = new ArrayList<ManPage>();
        this.loader = new SimpleFileParser();
    }

    public void setFile(String name) throws IOException {
        this.loader.setFile(name);
    }

    public void setFile(URL url) throws IOException {
    }

    public void setFile(InputStream input) throws IOException {
        this.loader.setFile(input);
    }

    public void complete(CompleteOperation completeOperation) {
        if (completeOperation.getBuffer().equals("m")) {
            completeOperation.getCompletionCandidates().add(new TerminalString("man"));
        } else if (completeOperation.getBuffer().equals("ma")) {
            completeOperation.getCompletionCandidates().add(new TerminalString("man"));
        } else if (completeOperation.getBuffer().equals("man")) {
            completeOperation.getCompletionCandidates().add(new TerminalString("man"));
        } else if (completeOperation.getBuffer().equals("man ")) {
            for (ManPage page : this.manPages) {
                completeOperation.getCompletionCandidates().add(new TerminalString("man " + page.getCommand()));
            }
        }
    }

    @Override
    public FileParser getFileParser() {
        return this.loader;
    }

    @Override
    public void displayBottom() throws IOException {
        this.writeToConsole(ANSI.INVERT_BACKGROUND);
        this.writeToConsole("Manual page " + this.loader.getName() + " line " + this.getTopVisibleRow() + " (press h for help or q to quit)" + "\u001b[0;39m");
    }
}

