/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.extensions.harlem;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.Random;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import org.aesh.readline.action.KeyAction;
import org.aesh.readline.completion.CompleteOperation;
import org.aesh.readline.completion.Completion;
import org.aesh.readline.terminal.formatting.Color;
import org.aesh.readline.terminal.formatting.TerminalCharacter;
import org.aesh.readline.terminal.formatting.TerminalColor;
import org.aesh.terminal.Connection;
import org.aesh.terminal.utils.ANSI;
import org.aesh.terminal.utils.Config;

public class Harlem
implements Completion {
    private int rows;
    private int columns;
    private char[] randomChars = new char[]{'@', '#', '$', '%', '&', '{', '}', '?', '-', '/', '\\'};
    private Color[] randomColors = new Color[]{Color.GREEN, Color.BLUE, Color.RED, Color.YELLOW, Color.DEFAULT};
    private Random random;
    private TerminalCharacter[][] terminalCharacters;
    private boolean allowDownload = false;
    private File harlemWav = new File(Config.getTmpDir() + Config.getPathSeparator() + "harlem.wav");
    private Connection connection;
    private boolean attached = true;

    public Harlem(Connection connection) {
        this.connection = connection;
        this.random = new Random();
    }

    public void afterAttach() throws IOException {
        this.rows = this.connection.size().getHeight();
        this.columns = this.connection.size().getWidth();
        this.terminalCharacters = new TerminalCharacter[this.rows][this.columns];
        this.connection.write(ANSI.ALTERNATE_BUFFER);
        if (!this.harlemWav.isFile()) {
            this.displayQuestion();
        } else {
            this.startHarlem();
        }
    }

    private void displayQuestion() throws IOException {
        this.connection.write("\u001b[" + this.rows + ";1H");
        this.connection.write("Allow harlem to save file to \"" + Config.getTmpDir() + "? (y or n)");
    }

    protected void afterDetach() throws IOException {
        this.connection.write(ANSI.MAIN_BUFFER);
        this.connection.write("\u001b[?25h");
        this.attached = false;
    }

    private void displayWait() throws IOException {
        this.connection.write("\u001b[?25l");
        this.connection.write("\u001b[" + this.rows / 2 + ";1H");
        this.connection.write("Buffering....  please wait.....");
    }

    private void displayIntro() throws IOException {
        int i;
        this.connection.write("\u001b[1;1H");
        TerminalCharacter startChar = new TerminalCharacter('|');
        for (i = 0; i < this.terminalCharacters.length; ++i) {
            for (int j = 0; j < this.terminalCharacters[i].length; ++j) {
                this.terminalCharacters[i][j] = startChar;
            }
        }
        for (i = 0; i < this.terminalCharacters.length; ++i) {
            StringBuilder sb = new StringBuilder();
            for (int j = 0; j < this.terminalCharacters[i].length; ++j) {
                if (j > 0) {
                    sb.append(this.terminalCharacters[i][j].toString(this.terminalCharacters[i][j]));
                    continue;
                }
                sb.append(this.terminalCharacters[i][j].toString());
            }
            this.connection.write(sb.toString());
        }
        int middleRow = this.rows / 2;
        int middleColumn = this.columns / 2;
        TerminalCharacter middleChar = this.terminalCharacters[middleRow][middleColumn];
        for (int i2 = 0; i2 < 33; ++i2) {
            try {
                Thread.sleep(450L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.connection.write("\u001b[" + middleRow + ";" + middleColumn + "H");
            this.connection.write(middleChar.toString());
            middleChar = new TerminalCharacter(this.getNextChar(middleChar.getCharacter()));
        }
        this.displayHarlem();
    }

    private char getNextChar(char prev) {
        if (prev == '|') {
            return '/';
        }
        if (prev == '/') {
            return '-';
        }
        if (prev == '-') {
            return '\\';
        }
        return '|';
    }

    private char getRandomChar() {
        return this.randomChars[this.random.nextInt(this.randomChars.length)];
    }

    private Color getRandomColor() {
        return this.randomColors[this.random.nextInt(this.randomColors.length)];
    }

    private void displayHarlem() throws IOException {
        for (int i = 0; i < 22; ++i) {
            try {
                Thread.sleep(630L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.displayCorus();
        }
    }

    private void displayCorus() throws IOException {
        this.connection.write("\u001b[1;1H");
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.terminalCharacters.length; ++i) {
            for (int j = 0; j < this.terminalCharacters[i].length; ++j) {
                if (j % 2 == 0) {
                    sb.append(new TerminalCharacter(' ').toString());
                    continue;
                }
                sb.append(new TerminalCharacter(this.getRandomChar(), new TerminalColor(this.getRandomColor(), Color.DEFAULT)).toString());
            }
        }
        this.connection.write(sb.toString());
    }

    public void processOperation(KeyAction operation) throws IOException {
        if (operation.getCodePointAt(0) == 121) {
            this.allowDownload = true;
            this.startHarlem();
        }
        if (operation.getCodePointAt(0) == 110) {
            this.startHarlem();
        }
        if (operation.getCodePointAt(0) == 113) {
            this.afterDetach();
        }
    }

    private void startHarlem() throws IOException {
        this.displayWait();
        this.playHarlem();
        this.displayIntro();
        this.afterDetach();
    }

    public void complete(CompleteOperation completeOperation) {
        if ("harlem".startsWith(completeOperation.getBuffer())) {
            completeOperation.addCompletionCandidate("harlem");
        }
    }

    private void playHarlem() {
        try {
            if (!this.harlemWav.isFile() && this.allowDownload) {
                this.saveHarlem(this.harlemWav);
            }
            Clip clip = AudioSystem.getClip();
            if (this.harlemWav.isFile()) {
                clip.open(AudioSystem.getAudioInputStream(this.harlemWav));
            } else {
                clip.open(AudioSystem.getAudioInputStream(new URL("https://dl.dropbox.com/u/30971563/harlem.wav")));
            }
            clip.start();
        }
        catch (Exception exc) {
            exc.printStackTrace(System.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveHarlem(File harlemWav) throws IOException {
        BufferedInputStream in = null;
        FileOutputStream fout = null;
        try {
            int count;
            in = new BufferedInputStream(new URL("https://dl.dropbox.com/u/30971563/harlem.wav").openStream());
            fout = new FileOutputStream(harlemWav);
            byte[] data = new byte[1024];
            while ((count = in.read(data, 0, 1024)) != -1) {
                fout.write(data, 0, count);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
            if (fout != null) {
                fout.close();
            }
        }
    }
}

