/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.extensions.manual.page;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.logging.Logger;
import org.aesh.extensions.manual.TerminalPage;
import org.aesh.extensions.util.FileParser;
import org.aesh.readline.action.KeyAction;
import org.aesh.readline.completion.Completion;
import org.aesh.readline.terminal.Key;
import org.aesh.readline.util.LoggerUtil;
import org.aesh.terminal.Attributes;
import org.aesh.terminal.Connection;
import org.aesh.terminal.utils.ANSI;
import org.aesh.terminal.utils.Config;

public abstract class FileDisplayer
implements Completion {
    private int rows;
    private int columns;
    private int topVisibleRow;
    private int topVisibleRowCache;
    private TerminalPage page;
    private StringBuilder number;
    private TerminalPage.Search search = TerminalPage.Search.NO_SEARCH;
    private StringBuilder searchBuilder;
    private List<Integer> searchLines;
    private Logger logger = LoggerUtil.getLogger((String)this.getClass().getName());
    private boolean attached = true;
    private Connection connection;

    public FileDisplayer() {
        this.number = new StringBuilder();
        this.searchBuilder = new StringBuilder();
    }

    public void setConnection(Connection conn) {
        this.connection = conn;
    }

    public void afterAttach() throws IOException {
        this.rows = this.connection.size().getHeight();
        this.columns = this.connection.size().getWidth();
        this.page = new TerminalPage(this.getFileParser(), this.columns);
        this.topVisibleRow = 0;
        this.topVisibleRowCache = -1;
        if (!this.page.hasData()) {
            this.connection.write("Missing filename (\"less --help\" for help)\n");
            this.afterDetach();
        } else {
            this.connection.write(ANSI.ALTERNATE_BUFFER);
            if (this.page.getFileName() != null) {
                this.display();
            } else {
                this.display();
            }
        }
    }

    protected void afterDetach() throws IOException {
        this.page.clear();
        this.topVisibleRow = 0;
        this.attached = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private KeyAction readInput() {
        Attributes attributes = this.connection.enterRawMode();
        CountDownLatch latch = new CountDownLatch(1);
        KeyAction[] action = new KeyAction[1];
        this.connection.setStdinHandler(keys -> {
            action[0] = new KeyAction((int[])keys){
                private int[] input;
                final /* synthetic */ int[] val$keys;
                {
                    this.val$keys = nArray;
                    this.input = this.val$keys;
                }

                public int getCodePointAt(int index) throws IndexOutOfBoundsException {
                    return this.input[index];
                }

                public int length() {
                    return this.input.length;
                }

                public String name() {
                    return "";
                }
            };
            latch.countDown();
        });
        try {
            latch.await();
            KeyAction keyAction = action[0];
            return keyAction;
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        finally {
            this.connection.setStdinHandler(null);
            this.connection.setAttributes(attributes);
        }
        return null;
    }

    public void processOperation() throws IOException, InterruptedException {
        KeyAction action = this.readInput();
        if (action.getCodePointAt(0) == 113) {
            if (this.search == TerminalPage.Search.SEARCHING) {
                this.searchBuilder.append((char)action.getCodePointAt(0));
                this.displayBottom();
            } else {
                this.clearNumber();
                this.afterDetach();
            }
        } else if (action.getCodePointAt(0) == 106 || Key.DOWN.equalTo(action) || Key.ENTER.equalTo(action)) {
            if (this.search == TerminalPage.Search.SEARCHING) {
                if (action.getCodePointAt(0) == 106) {
                    this.searchBuilder.append((char)action.getCodePointAt(0));
                    this.displayBottom();
                } else if (Key.ENTER.equalTo(action)) {
                    this.search = TerminalPage.Search.RESULT;
                    this.findSearchWord(true);
                }
            } else {
                this.topVisibleRow += this.getNumber();
                if (this.topVisibleRow > this.page.size() - this.rows - 1) {
                    this.topVisibleRow = this.page.size() - this.rows - 1;
                    if (this.topVisibleRow < 0) {
                        this.topVisibleRow = 0;
                    }
                    this.display();
                } else {
                    this.display();
                }
                this.clearNumber();
            }
        } else if (action.getCodePointAt(0) == 107 || Key.UP.equalTo(action)) {
            if (this.search == TerminalPage.Search.SEARCHING) {
                if (action.getCodePointAt(0) == 107) {
                    this.searchBuilder.append((char)action.getCodePointAt(0));
                }
                this.displayBottom();
            } else {
                this.topVisibleRow -= this.getNumber();
                if (this.topVisibleRow < 0) {
                    this.topVisibleRow = 0;
                }
                this.display();
                this.clearNumber();
            }
        } else if (action.getCodePointAt(0) == 6 || Key.PGDOWN.equalTo(action) || action.getCodePointAt(0) == 32) {
            if (this.search != TerminalPage.Search.SEARCHING) {
                this.topVisibleRow += (this.rows - 1) * this.getNumber();
                if (this.topVisibleRow > this.page.size() - this.rows - 1) {
                    this.topVisibleRow = this.page.size() - this.rows - 1;
                    if (this.topVisibleRow < 0) {
                        this.topVisibleRow = 0;
                    }
                    this.display();
                } else {
                    this.display();
                }
                this.clearNumber();
            }
        } else if (action.getCodePointAt(0) == 2 || Key.PGUP.equalTo(action)) {
            if (this.search != TerminalPage.Search.SEARCHING) {
                this.topVisibleRow -= (this.rows - 1) * this.getNumber();
                if (this.topVisibleRow < 0) {
                    this.topVisibleRow = 0;
                }
                this.display();
                this.clearNumber();
            }
        } else if (action.getCodePointAt(0) == 47) {
            if (this.search == TerminalPage.Search.NO_SEARCH || this.search == TerminalPage.Search.RESULT) {
                this.search = TerminalPage.Search.SEARCHING;
                this.searchBuilder = new StringBuilder();
                this.displayBottom();
            } else if (this.search == TerminalPage.Search.SEARCHING) {
                this.searchBuilder.append((char)action.getCodePointAt(0));
                this.displayBottom();
            }
        } else if (action.getCodePointAt(0) == 110) {
            if (this.search == TerminalPage.Search.SEARCHING) {
                this.searchBuilder.append((char)action.getCodePointAt(0));
                this.displayBottom();
            } else if (this.search == TerminalPage.Search.RESULT) {
                if (this.searchLines.size() > 0) {
                    for (Integer i : this.searchLines) {
                        if (i <= this.topVisibleRow + 1) continue;
                        this.topVisibleRow = i - 1;
                        this.display();
                        return;
                    }
                    this.displayBottom();
                } else {
                    this.displayBottom();
                }
            }
        } else if (action.getCodePointAt(0) == 78) {
            if (this.search == TerminalPage.Search.SEARCHING) {
                this.searchBuilder.append((char)action.getCodePointAt(0));
                this.displayBottom();
            } else if (this.search == TerminalPage.Search.RESULT && this.searchLines.size() > 0) {
                for (int i = this.searchLines.size() - 1; i >= 0; --i) {
                    if (this.searchLines.get(i) >= this.topVisibleRow) continue;
                    this.topVisibleRow = this.searchLines.get(i) - 1;
                    if (this.topVisibleRow < 0) {
                        this.topVisibleRow = 0;
                    }
                    this.display();
                    return;
                }
                this.displayBottom();
            }
        } else if (action.getCodePointAt(0) == 71) {
            if (this.search == TerminalPage.Search.SEARCHING) {
                this.searchBuilder.append((char)action.getCodePointAt(0));
                this.displayBottom();
            } else {
                if (this.number.length() == 0 || this.getNumber() == 0) {
                    this.topVisibleRow = this.page.size() - this.rows - 1;
                    this.display();
                } else {
                    this.topVisibleRow = this.getNumber() - 1;
                    if (this.topVisibleRow > this.page.size() - this.rows - 1) {
                        this.topVisibleRow = this.page.size() - this.rows - 1;
                        this.display();
                    } else {
                        this.display();
                    }
                }
                this.clearNumber();
            }
        } else if (Character.isDigit(action.getCodePointAt(0))) {
            if (this.search == TerminalPage.Search.SEARCHING) {
                this.searchBuilder.append((char)action.getCodePointAt(0));
                this.displayBottom();
            } else {
                this.number.append(Character.getNumericValue(action.getCodePointAt(0)));
                this.display();
            }
        } else if (this.search == TerminalPage.Search.SEARCHING && Character.isAlphabetic(action.getCodePointAt(0))) {
            this.searchBuilder.append((char)action.getCodePointAt(0));
            this.displayBottom();
        }
    }

    private void display() throws IOException {
        if (this.topVisibleRow != this.topVisibleRowCache) {
            this.connection.stdoutHandler().accept(ANSI.CLEAR_SCREEN);
            if (this.search == TerminalPage.Search.RESULT && this.searchLines.size() > 0) {
                String searchWord = this.searchBuilder.toString();
                for (int i = this.topVisibleRow; i < this.topVisibleRow + this.rows - 1; ++i) {
                    if (i >= this.page.size()) continue;
                    String line = this.page.getLine(i);
                    if (line.contains(searchWord)) {
                        this.displaySearchLine(line, searchWord);
                    } else {
                        this.connection.write(line);
                    }
                    this.connection.write(Config.getLineSeparator());
                }
                this.topVisibleRowCache = this.topVisibleRow;
            } else {
                for (int i = this.topVisibleRow; i < this.topVisibleRow + this.rows - 1; ++i) {
                    if (i >= this.page.size()) continue;
                    this.connection.write(this.page.getLine(i) + Config.getLineSeparator());
                }
                this.topVisibleRowCache = this.topVisibleRow;
            }
            this.displayBottom();
        }
    }

    private void displaySearchLine(String line, String searchWord) throws IOException {
        int start = line.indexOf(searchWord);
        this.connection.write(line.substring(0, start));
        this.connection.write(ANSI.INVERT_BACKGROUND);
        this.connection.write(searchWord);
        this.connection.write("\u001b[0m");
        this.connection.write(line.substring(start + searchWord.length(), line.length()));
    }

    public abstract FileParser getFileParser();

    public abstract void displayBottom() throws IOException;

    public void writeToConsole(String word) throws IOException {
        this.connection.write(word);
    }

    public void clearBottomLine() throws IOException {
        this.connection.stdoutHandler().accept(ANSI.printAnsi((String)"0G"));
        this.connection.stdoutHandler().accept(ANSI.printAnsi((String)"2K"));
    }

    public boolean isAtBottom() {
        return this.topVisibleRow >= this.page.size() - this.rows - 1;
    }

    public boolean isAtTop() {
        return this.topVisibleRow == 0;
    }

    public TerminalPage.Search getSearchStatus() {
        return this.search;
    }

    public String getSearchWord() {
        return this.searchBuilder.toString();
    }

    public int getTopVisibleRow() {
        return this.topVisibleRow + 1;
    }

    private void findSearchWord(boolean forward) throws IOException {
        this.logger.info("searching for: " + this.searchBuilder.toString());
        this.searchLines = this.page.findWord(this.searchBuilder.toString());
        this.logger.info("found: " + this.searchLines);
        if (this.searchLines.size() > 0) {
            for (Integer i : this.searchLines) {
                if (i <= this.topVisibleRow) continue;
                this.topVisibleRow = i - 1;
                this.display();
                return;
            }
        } else {
            this.search = TerminalPage.Search.NOT_FOUND;
            this.displayBottom();
        }
    }

    private int getNumber() {
        if (this.number.length() > 0) {
            return Integer.parseInt(this.number.toString());
        }
        return 1;
    }

    private void clearNumber() {
        this.number = new StringBuilder();
    }

    private static enum Background {
        NORMAL,
        INVERSE;

    }
}

