/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.http.server;

import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.io.IOException;
import java.io.Serializable;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.aesh.terminal.http.Status;
import org.aesh.terminal.http.server.TaskStatusUpdateEventDeserializer;

@JsonDeserialize(using=TaskStatusUpdateEventDeserializer.class)
public class TaskStatusUpdateEvent
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(TaskStatusUpdateEvent.class.getName());
    private final String taskId;
    private final Status oldStatus;
    private final Status newStatus;
    private final String context;

    public TaskStatusUpdateEvent(String taskId, Status oldStatus, Status newStatus, String context) {
        this.taskId = taskId;
        this.oldStatus = oldStatus;
        this.newStatus = newStatus;
        this.context = context;
    }

    public String getTaskId() {
        return this.taskId;
    }

    public Status getOldStatus() {
        return this.oldStatus;
    }

    public Status getNewStatus() {
        return this.newStatus;
    }

    public String getContext() {
        return this.context;
    }

    public String toString() {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return mapper.writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            LOGGER.log(Level.SEVERE, "Cannot serialize object.", e);
            return null;
        }
    }

    public static TaskStatusUpdateEvent fromJson(String serialized) throws IOException {
        ObjectMapper mapper = new ObjectMapper();
        try {
            return (TaskStatusUpdateEvent)mapper.readValue(serialized, TaskStatusUpdateEvent.class);
        }
        catch (JsonParseException | JsonMappingException e) {
            LOGGER.log(Level.SEVERE, "Cannot deserialize object from json", e);
            throw e;
        }
    }
}

