/*
 * Decompiled with CFR 0.152.
 */
package org.aesh.terminal.ssh.tty;

import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import org.aesh.terminal.Connection;
import org.aesh.terminal.ssh.TtyCommand;
import org.aesh.terminal.ssh.netty.NettyIoServiceFactoryFactory;
import org.aesh.terminal.ssh.netty.NettyIoSession;
import org.aesh.terminal.ssh.tty.SshTtyTestBase;
import org.apache.sshd.common.io.IoServiceFactoryFactory;
import org.apache.sshd.common.session.Session;
import org.apache.sshd.server.SshServer;
import org.junit.After;
import org.junit.Before;

public class NettySshTtyTest
extends SshTtyTestBase {
    private EventLoopGroup eventLoopGroup;

    @Before
    public void before() {
        this.eventLoopGroup = new NioEventLoopGroup();
    }

    @Override
    @After
    public void after() throws Exception {
        Future future = this.eventLoopGroup.shutdownGracefully();
        this.assertTrue(future.await(30L, TimeUnit.SECONDS));
    }

    @Override
    protected SshServer createServer() {
        SshServer sshd = SshServer.setUpDefaultServer();
        sshd.setIoServiceFactoryFactory((IoServiceFactoryFactory)new NettyIoServiceFactoryFactory(this.eventLoopGroup));
        return sshd;
    }

    @Override
    protected TtyCommand createConnection(Consumer<Connection> onConnect) {
        return new TtyCommand(this.charset, onConnect){

            public void execute(Runnable task) {
                Session session = this.session.getSession();
                NettyIoSession ioSession = (NettyIoSession)session.getIoSession();
                ioSession.execute(task);
            }
        };
    }

    protected void assertThreading(Thread connThread, Thread schedulerThread) throws Exception {
        this.assertTrue(connThread.getName().startsWith("nioEventLoopGroup"));
        this.assertEquals(connThread, schedulerThread);
    }
}

