/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.impl.containerless;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.net.UnknownHostException;
import org.arquillian.cube.docker.impl.requirement.RequiresDocker;
import org.arquillian.cube.impl.containerless.DaytimeServer;
import org.arquillian.cube.requirement.ArquillianConditionalRunner;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.Archive;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.asset.Asset;
import org.jboss.shrinkwrap.api.asset.StringAsset;
import org.jboss.shrinkwrap.api.spec.JavaArchive;
import org.jboss.shrinkwrap.resolver.api.maven.Maven;
import org.jboss.shrinkwrap.resolver.api.maven.MavenFormatStage;
import org.jboss.shrinkwrap.resolver.api.maven.MavenStrategyStage;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@Category(value={RequiresDocker.class})
@RunWith(value=ArquillianConditionalRunner.class)
public class DaytimeTest {
    private static final String LINE_SEPARATOR = System.getProperty("line.separator");

    @Deployment(testable=false)
    public static JavaArchive createDeployment() {
        JavaArchive[] undertow = (JavaArchive[])((MavenFormatStage)((MavenStrategyStage)Maven.resolver().resolve("io.undertow:undertow-core:1.1.1.Final")).withTransitivity()).as(JavaArchive.class);
        JavaArchive jar = (JavaArchive)((JavaArchive)ShrinkWrap.create(JavaArchive.class, (String)"daytime.jar")).addClass(DaytimeServer.class);
        for (JavaArchive javaArchive : undertow) {
            jar.merge((Archive)javaArchive);
        }
        jar.addAsManifestResource((Asset)new StringAsset("Main-Class: org.arquillian.cube.impl.containerless.DaytimeServer" + LINE_SEPARATOR), "MANIFEST.MF");
        return jar;
    }

    @Test
    public void shouldReturnDateFromDaytimeServer(@ArquillianResource URL base) {
        try (BufferedReader in = new BufferedReader(new InputStreamReader(base.openStream()));){
            String userInput = in.readLine();
            Assert.assertThat((Object)userInput, (Matcher)CoreMatchers.notNullValue());
        }
        catch (UnknownHostException e) {
            Assert.fail((String)"Don't know about host ");
        }
        catch (IOException e) {
            Assert.fail((String)"Couldn't get I/O for the connection to ");
        }
    }
}

