/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.servlet;

import com.github.dockerjava.api.DockerClient;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.List;
import org.arquillian.cube.CubeController;
import org.arquillian.cube.CubeID;
import org.arquillian.cube.TopContainer;
import org.arquillian.cube.servlet.HelloWorldServlet;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.jboss.arquillian.container.test.api.Deployment;
import org.jboss.arquillian.junit.Arquillian;
import org.jboss.arquillian.test.api.ArquillianResource;
import org.jboss.shrinkwrap.api.ShrinkWrap;
import org.jboss.shrinkwrap.api.spec.WebArchive;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;

@RunWith(value=Arquillian.class)
public class HelloWorldServletTest {
    @Rule
    public TemporaryFolder folder = new TemporaryFolder();

    @Deployment(testable=false)
    public static WebArchive create() {
        return (WebArchive)((WebArchive)ShrinkWrap.create(WebArchive.class, (String)"hello.war")).addClass(HelloWorldServlet.class);
    }

    @Test
    public void should_parse_and_load_configuration_file(@ArquillianResource URL base) throws IOException {
        String inputLine;
        URL obj = new URL(base, "HelloWorld");
        HttpURLConnection con = (HttpURLConnection)obj.openConnection();
        con.setRequestMethod("GET");
        BufferedReader in = new BufferedReader(new InputStreamReader(con.getInputStream()));
        StringBuffer response = new StringBuffer();
        while ((inputLine = in.readLine()) != null) {
            response.append(inputLine);
        }
        in.close();
        Assert.assertThat((Object)response.toString(), (Matcher)CoreMatchers.is((Object)"Hello World"));
    }

    @Test
    public void should_get_running_logs(@ArquillianResource CubeController cubeController, @ArquillianResource CubeID cubeID) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        cubeController.copyLog(cubeID, false, true, true, false, -1, (OutputStream)bos);
        String log = new String(bos.toByteArray());
        Assert.assertThat((Object)log, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void should_execute_top(@ArquillianResource CubeController cubeController, @ArquillianResource CubeID cubeID) {
        TopContainer top = cubeController.top(cubeID);
        Assert.assertThat((Object)top, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)top.getProcesses(), (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)top.getTitles(), (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void should_get_changes_on_container(@ArquillianResource CubeController cubeController, @ArquillianResource CubeID cubeID) {
        List changesOnFilesystem = cubeController.changesOnFilesystem(cubeID);
        Assert.assertThat((Object)changesOnFilesystem, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)(changesOnFilesystem.size() > 0 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void should_copy_files_from_container(@ArquillianResource CubeController cubeController, @ArquillianResource CubeID cubeID) throws IOException {
        File newFolder = this.folder.newFolder();
        cubeController.copyFileDirectoryFromContainer(cubeID, "/tomcat/logs", newFolder.getAbsolutePath());
        File logFolder = newFolder.listFiles()[0];
        Assert.assertThat((Object)logFolder, (Matcher)CoreMatchers.notNullValue());
        Assert.assertThat((Object)(logFolder.listFiles().length > 0 ? 1 : 0), (Matcher)CoreMatchers.is((Object)true));
    }

    @Test
    public void should_enrich_test_with_docker_client(@ArquillianResource CubeController cubeController) {
        Assert.assertThat((Object)cubeController, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void should_enrich_test_with_docker_client(@ArquillianResource DockerClient dockerClient) {
        Assert.assertThat((Object)dockerClient, (Matcher)CoreMatchers.notNullValue());
    }

    @Test
    public void should_enrich_test_with_cube_id(@ArquillianResource CubeID cubeId) {
        Assert.assertThat((Object)cubeId, (Matcher)CoreMatchers.notNullValue());
    }
}

