/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.junit.rule;

import java.io.File;
import java.util.ArrayList;
import org.arquillian.cube.docker.impl.client.SystemPropertiesCubeSetter;
import org.arquillian.cube.docker.impl.client.config.Await;
import org.arquillian.cube.docker.impl.client.containerobject.dsl.BindMode;
import org.arquillian.cube.docker.impl.client.containerobject.dsl.Container;
import org.arquillian.cube.docker.impl.client.containerobject.dsl.ContainerBuilder;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.docker.impl.model.DockerCube;
import org.arquillian.cube.docker.junit.DockerClientInitializer;
import org.arquillian.cube.docker.junit.Injector;
import org.arquillian.cube.docker.junit.rule.NetworkDslRule;
import org.arquillian.cube.impl.model.LocalCubeRegistry;
import org.arquillian.cube.spi.CubeOutput;
import org.arquillian.cube.spi.CubeRegistry;
import org.arquillian.cube.spi.event.lifecycle.AfterDestroy;
import org.arquillian.cube.spi.event.lifecycle.AfterStart;
import org.jboss.arquillian.test.spi.event.suite.AfterSuite;
import org.jboss.arquillian.test.spi.event.suite.BeforeSuite;
import org.jboss.shrinkwrap.api.Archive;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

public class ContainerDslRule
implements TestRule {
    private DockerClientExecutor dockerClientExecutor;
    private SystemPropertiesCubeSetter systemPropertiesCubeSetter = new SystemPropertiesCubeSetter();
    private ContainerBuilder.ContainerOptionsBuilder containerBuilder;
    private Container container;

    public ContainerDslRule(File directory, String imageId) {
        this.containerBuilder = Container.withContainerName((String)imageId).fromBuildDirectory(directory.getAbsolutePath());
        this.initializeDockerClient();
    }

    public ContainerDslRule(Archive<?> buildDirectory, String imageId) {
        this.containerBuilder = Container.withContainerName((String)imageId).fromBuildDirectory(buildDirectory);
        this.initializeDockerClient();
    }

    public ContainerDslRule(String image) {
        this(image, ContainerDslRule.convertImageToId(image));
    }

    public ContainerDslRule(String image, String id) {
        this.containerBuilder = Container.withContainerName((String)id).fromImage(image);
        this.initializeDockerClient();
    }

    private static String convertImageToId(String imageId) {
        return imageId.replace('/', '_').replace(':', '_').replace('.', '_');
    }

    private void initializeDockerClient() {
        this.dockerClientExecutor = DockerClientInitializer.initialize();
        this.systemPropertiesCubeSetter.createDockerHostProperty(new BeforeSuite(), this.dockerClientExecutor);
    }

    public ContainerDslRule withExposedPorts(Integer ... ports) {
        this.containerBuilder.withExposedPorts(ports);
        return this;
    }

    public ContainerDslRule withExposedPorts(String ... ports) {
        this.containerBuilder.withExposedPorts(ports);
        return this;
    }

    public ContainerDslRule withPortBinding(Integer ... ports) {
        this.containerBuilder.withPortBinding(ports);
        return this;
    }

    public ContainerDslRule withPortBinding(String ... ports) {
        this.containerBuilder.withPortBinding(ports);
        return this;
    }

    public ContainerDslRule withEnvironment(String key, Object value, Object ... keyValues) {
        this.containerBuilder.withEnvironment(key, value, keyValues);
        return this;
    }

    public ContainerDslRule withCommand(String command) {
        this.containerBuilder.withCommand(command);
        return this;
    }

    public ContainerDslRule withCommand(String ... command) {
        this.containerBuilder.withCommand(command);
        return this;
    }

    public ContainerDslRule withVolume(String hostPath, String containerPath) {
        return this.withVolume(hostPath, containerPath, BindMode.READ_WRITE);
    }

    public ContainerDslRule withVolume(String hostPath, String containerPath, BindMode bindMode) {
        this.containerBuilder.withVolume(hostPath, containerPath, bindMode);
        return this;
    }

    public ContainerDslRule withNetworkMode(String networkMode) {
        this.containerBuilder.withNetworkMode(networkMode);
        return this;
    }

    public ContainerDslRule withNetworkMode(NetworkDslRule networkMode) {
        return this.withNetworkMode(networkMode.getNetworkName());
    }

    public ContainerDslRule withNetworks(String ... networks) {
        this.containerBuilder.withNetworks(networks);
        return this;
    }

    public ContainerDslRule withPriviledgedMode(boolean mode) {
        this.containerBuilder.withPriviledgedMode(mode);
        return this;
    }

    public ContainerDslRule withLink(String link) {
        this.containerBuilder.withLink(link);
        return this;
    }

    public ContainerDslRule withLink(String service, String alias) {
        return this.withLink(service + ":" + alias);
    }

    public ContainerDslRule withAwaitStrategy(Await awaitStrategy) {
        this.containerBuilder.withAwaitStrategy(awaitStrategy);
        return this;
    }

    public String getIpAddress() {
        return this.container.getIpAddress();
    }

    public int getBindPort(int exposedPort) {
        return this.container.getBindPort(exposedPort);
    }

    public String getLog() {
        return this.container.getLog();
    }

    public CubeOutput exec(String ... commands) {
        return this.container.exec(commands);
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void evaluate() throws Throwable {
                ArrayList<Throwable> errors = new ArrayList<Throwable>();
                ContainerDslRule.this.container = ContainerDslRule.this.containerBuilder.build();
                LocalCubeRegistry localCubeRegistry = new LocalCubeRegistry();
                DockerCube dockerCube = Injector.prepareContainer(ContainerDslRule.this.container, ContainerDslRule.this.dockerClientExecutor, localCubeRegistry);
                try {
                    dockerCube.create();
                    dockerCube.start();
                    ContainerDslRule.this.systemPropertiesCubeSetter.createCubeSystemProperties(new AfterStart(dockerCube.getId()), (CubeRegistry)localCubeRegistry);
                    base.evaluate();
                }
                catch (Throwable t) {
                    errors.add(t);
                }
                finally {
                    dockerCube.stop();
                    dockerCube.destroy();
                    ContainerDslRule.this.systemPropertiesCubeSetter.removeCubeSystemProperties(new AfterDestroy(dockerCube.getId()));
                    ContainerDslRule.this.systemPropertiesCubeSetter.removeDockerHostProperty(new AfterSuite());
                }
                MultipleFailureException.assertEmpty(errors);
            }
        };
    }
}

