/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.junit.rule;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.arquillian.cube.docker.impl.client.containerobject.dsl.Network;
import org.arquillian.cube.docker.impl.client.containerobject.dsl.NetworkBuilder;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.docker.junit.DockerClientInitializer;
import org.arquillian.cube.spi.metadata.IsNetworkContainerObject;
import org.arquillian.cube.spi.metadata.NetworkMetadata;
import org.junit.rules.TestRule;
import org.junit.runner.Description;
import org.junit.runners.model.MultipleFailureException;
import org.junit.runners.model.Statement;

public class NetworkDslRule
implements TestRule {
    private DockerClientExecutor dockerClientExecutor;
    private NetworkBuilder networkBuilder;
    private Network network;

    public NetworkDslRule(String networkId) {
        this.networkBuilder = Network.withDefaultDriver((String)networkId);
        this.initializeDockerClient();
    }

    public NetworkDslRule(String networkName, String driver) {
        this.networkBuilder = Network.withDriver((String)networkName, (String)driver);
        this.initializeDockerClient();
    }

    private void initializeDockerClient() {
        this.dockerClientExecutor = DockerClientInitializer.initialize();
    }

    public List<String> getNetworks() {
        return this.dockerClientExecutor.getNetworks().stream().map(com.github.dockerjava.api.model.Network::getName).collect(Collectors.toList());
    }

    public String getNetworkName() {
        return this.network.getId();
    }

    public Statement apply(final Statement base, Description description) {
        return new Statement(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Unable to fully structure code
             */
            public void evaluate() throws Throwable {
                errors = new ArrayList<Throwable>();
                NetworkDslRule.this.network = NetworkDslRule.this.networkBuilder.build();
                dockerNetwork = NetworkDslRule.this.network.getNetwork();
                networkId = null;
                try {
                    networkId = NetworkDslRule.this.dockerClientExecutor.createNetwork(NetworkDslRule.this.network.getId(), dockerNetwork);
                    dockerNetwork.addMetadata(IsNetworkContainerObject.class, (NetworkMetadata)new IsNetworkContainerObject());
                    base.evaluate();
                    ** if (networkId == null) goto lbl-1000
                }
                catch (Throwable t) {
                    try {
                        errors.add(t);
                        ** if (networkId == null) goto lbl-1000
                    }
                    catch (Throwable var5_5) {
                        if (networkId != null) {
                            NetworkDslRule.this.dockerClientExecutor.removeNetwork(networkId);
                        }
                        throw var5_5;
                    }
lbl-1000:
                    // 1 sources

                    {
                        NetworkDslRule.this.dockerClientExecutor.removeNetwork(networkId);
                    }
lbl-1000:
                    // 2 sources

                    {
                    }
                }
lbl-1000:
                // 1 sources

                {
                    NetworkDslRule.this.dockerClientExecutor.removeNetwork(networkId);
                }
lbl-1000:
                // 2 sources

                {
                }
                MultipleFailureException.assertEmpty(errors);
            }
        };
    }
}

