/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.reporter;

import com.github.dockerjava.api.command.InspectContainerResponse;
import com.github.dockerjava.api.model.Version;
import com.mxgraph.layout.hierarchical.mxHierarchicalLayout;
import com.mxgraph.util.mxCellRenderer;
import com.mxgraph.util.mxConstants;
import com.mxgraph.view.mxGraph;
import java.awt.Color;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import org.arquillian.cube.docker.impl.client.CubeDockerConfiguration;
import org.arquillian.cube.docker.impl.client.config.CubeContainer;
import org.arquillian.cube.docker.impl.client.config.DockerCompositions;
import org.arquillian.cube.docker.impl.client.config.Link;
import org.arquillian.cube.docker.impl.client.reporter.CubeStatistics;
import org.arquillian.cube.docker.impl.client.reporter.DockerEnvironmentReportKey;
import org.arquillian.cube.docker.impl.client.utils.NumberConversion;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.docker.impl.reporter.DockerContainerSection;
import org.arquillian.cube.spi.CubeRegistry;
import org.arquillian.cube.spi.event.lifecycle.AfterAutoStart;
import org.arquillian.cube.spi.event.lifecycle.BeforeStop;
import org.arquillian.reporter.api.builder.Reporter;
import org.arquillian.reporter.api.builder.report.ReportBuilder;
import org.arquillian.reporter.api.event.SectionEvent;
import org.arquillian.reporter.api.model.StringKey;
import org.arquillian.reporter.api.model.entry.Entry;
import org.arquillian.reporter.api.model.entry.FileEntry;
import org.arquillian.reporter.config.ReporterConfiguration;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.jboss.arquillian.test.spi.event.suite.Before;

public class TakeDockerEnvironment {
    private static Logger log = Logger.getLogger(TakeDockerEnvironment.class.getName());
    private static FileEntry EMPTY_SCREENSHOT = new FileEntry((String)null);
    private CubeStatistics statsBeforeMethod;
    private CubeStatistics statsAfterMethod;
    @Inject
    Event<SectionEvent> reportEvent;

    public void reportDockerEnvironment(@Observes AfterAutoStart event, CubeDockerConfiguration cubeDockerConfiguration, DockerClientExecutor executor, ReporterConfiguration reporterConfiguration) {
        ReportBuilder reportBuilder = Reporter.createReport((StringKey)DockerEnvironmentReportKey.DOCKER_ENVIRONMENT).addReport(this.createDockerInfoGroup(executor));
        reportBuilder.addKeyValueEntry(DockerEnvironmentReportKey.DOCKER_COMPOSITION_SCHEMA, (Entry)this.createDockerCompositionSchema(cubeDockerConfiguration, reporterConfiguration));
        reportBuilder.addKeyValueEntry(DockerEnvironmentReportKey.NETWORK_TOPOLOGY_SCHEMA, (Entry)this.createNetworkTopologyGraph(cubeDockerConfiguration, executor, reporterConfiguration));
        reportBuilder.inSection((SectionEvent)DockerContainerSection.standalone()).fire(this.reportEvent);
    }

    public void captureContainerStatsBeforeTest(@Observes Before before, DockerClientExecutor executor, CubeRegistry cubeRegistry) throws IOException {
        this.captureStats(executor, cubeRegistry, "before", false);
    }

    public void reportContainerStatsAfterTest(@Observes After after, DockerClientExecutor executor, CubeRegistry cubeRegistry) throws IOException {
        this.captureStats(executor, cubeRegistry, "after", false);
    }

    public void reportContainerLogs(@Observes BeforeStop beforeStop, DockerClientExecutor executor, ReporterConfiguration reporterConfiguration) throws IOException {
        String cubeId = beforeStop.getCubeId();
        if (cubeId != null) {
            File logFile = new File(this.createContainerLogDirectory(new File(reporterConfiguration.getRootDirectory())), cubeId + ".log");
            Path rootDir = Paths.get(reporterConfiguration.getRootDirectory(), new String[0]);
            Path relativePath = rootDir.relativize(logFile.toPath());
            executor.copyLog(beforeStop.getCubeId(), false, true, true, true, -1, (OutputStream)new FileOutputStream(logFile));
            Reporter.createReport().addKeyValueEntry(DockerEnvironmentReportKey.LOG_PATH, (Entry)new FileEntry(relativePath)).inSection((SectionEvent)new DockerContainerSection(cubeId)).fire(this.reportEvent);
        }
    }

    public void captureStats(DockerClientExecutor executor, CubeRegistry cubeRegistry, String when, Boolean decimal) throws IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileEntry createDockerCompositionSchema(CubeDockerConfiguration cubeDockerConfiguration, ReporterConfiguration reporterConfiguration) {
        mxGraph graph = new mxGraph();
        Object parent = graph.getDefaultParent();
        graph.setAutoSizeCells(true);
        graph.getModel().beginUpdate();
        try {
            DockerCompositions dockerContainersContent = cubeDockerConfiguration.getDockerContainersContent();
            Map containers = dockerContainersContent.getContainers();
            HashMap<String, Object> insertedVertex = new HashMap<String, Object>();
            for (Map.Entry containerEntry : containers.entrySet()) {
                String containerId = (String)containerEntry.getKey();
                CubeContainer cubeContainer = (CubeContainer)containerEntry.getValue();
                this.updateGraph(graph, parent, insertedVertex, containerId, cubeContainer);
            }
        }
        finally {
            graph.getModel().endUpdate();
        }
        mxHierarchicalLayout layout = new mxHierarchicalLayout(graph, 7);
        layout.execute(graph.getDefaultParent());
        return this.generateCompositionSchemaImage(graph, reporterConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileEntry createNetworkTopologyGraph(CubeDockerConfiguration cubeDockerConfiguration, DockerClientExecutor executor, ReporterConfiguration reporterConfiguration) {
        mxGraph graph = new mxGraph();
        Object parent = graph.getDefaultParent();
        graph.setAutoSizeCells(true);
        graph.getModel().beginUpdate();
        try {
            DockerCompositions dockerCompositions = cubeDockerConfiguration.getDockerContainersContent();
            Map containers = dockerCompositions.getContainers();
            HashMap<String, Object> insertedVertex = new HashMap<String, Object>();
            for (Map.Entry container : containers.entrySet()) {
                String containerId = (String)container.getKey();
                Object containerName = graph.insertVertex(parent, null, (Object)containerId, 0.0, 0.0, 80.0, 30.0);
                CubeContainer cubeContainer = (CubeContainer)container.getValue();
                if (cubeContainer.isManual()) continue;
                HashSet<String> nwList = new HashSet<String>();
                if (cubeContainer.getNetworkMode() != null) {
                    nwList.add(cubeContainer.getNetworkMode());
                } else {
                    InspectContainerResponse inspect = executor.inspectContainer(containerId);
                    String defaultNetwork = inspect.getHostConfig().getNetworkMode();
                    nwList.add(defaultNetwork);
                }
                if (cubeContainer.getNetworks() != null) {
                    nwList.addAll(cubeContainer.getNetworks());
                }
                for (String nw : nwList) {
                    Object nwName = null;
                    if (insertedVertex.containsKey(nw)) {
                        nwName = insertedVertex.get(nw);
                    } else {
                        nwName = graph.insertVertex(parent, null, (Object)nw, 0.0, 0.0, 60.0, 20.0);
                        graph.setCellStyles(mxConstants.STYLE_FILLCOLOR, "#00FF00", new Object[]{nwName});
                    }
                    graph.updateCellSize(nwName);
                    graph.insertEdge(parent, null, (Object)nw, containerName, nwName);
                    insertedVertex.put(nw, nwName);
                }
            }
        }
        finally {
            graph.getModel().endUpdate();
        }
        mxHierarchicalLayout layout = new mxHierarchicalLayout(graph, 7);
        layout.execute(graph.getDefaultParent());
        return this.generateNetworkTopologyImage(graph, reporterConfiguration);
    }

    private void updateGraph(mxGraph graph, Object parent, Map<String, Object> insertedVertex, String containerId, CubeContainer cubeContainer) {
        if (insertedVertex.containsKey(containerId)) {
            Object currentContainer = insertedVertex.get(containerId);
            this.createDirectLinks(graph, parent, insertedVertex, cubeContainer, currentContainer);
        } else {
            Object currentContainer = graph.insertVertex(parent, null, (Object)containerId, 0.0, 0.0, 80.0, 30.0);
            graph.updateCellSize(currentContainer);
            insertedVertex.put(containerId, currentContainer);
            this.createDirectLinks(graph, parent, insertedVertex, cubeContainer, currentContainer);
        }
    }

    private void createDirectLinks(mxGraph graph, Object parent, Map<String, Object> insertedVertex, CubeContainer cubeContainer, Object currentContainer) {
        if (cubeContainer.getLinks() != null) {
            for (Link link : cubeContainer.getLinks()) {
                String linkId = link.getName();
                Object linkContainer = null;
                linkContainer = insertedVertex.containsKey(linkId) ? insertedVertex.get(linkId) : graph.insertVertex(parent, null, (Object)linkId, 0.0, 0.0, 80.0, 30.0);
                graph.updateCellSize(currentContainer);
                graph.insertEdge(parent, null, (Object)link.getAlias(), currentContainer, linkContainer);
                insertedVertex.put(linkId, linkContainer);
            }
        }
    }

    private FileEntry generateCompositionSchemaImage(mxGraph graph, ReporterConfiguration reporterConfiguration) {
        File imageFile = new File(this.createSchemasDirectory(new File(reporterConfiguration.getRootDirectory())), "docker_composition.png");
        try {
            return this.createScreenshotEntry(imageFile, graph, reporterConfiguration);
        }
        catch (IOException e) {
            log.log(Level.WARNING, String.format("Docker compositions schema could not be generated because of %s.", e));
            return EMPTY_SCREENSHOT;
        }
    }

    private FileEntry generateNetworkTopologyImage(mxGraph graph, ReporterConfiguration reporterConfiguration) {
        try {
            File imageFile = new File(this.createNetworkTopologyDirectory(new File(reporterConfiguration.getRootDirectory())), "docker_network_topology.png");
            return this.createScreenshotEntry(imageFile, graph, reporterConfiguration);
        }
        catch (IOException e) {
            log.log(Level.WARNING, String.format("Docker container network toplogy could not be generated because of %s.", e));
            return EMPTY_SCREENSHOT;
        }
    }

    private FileEntry createScreenshotEntry(File imageFile, mxGraph graph, ReporterConfiguration reporterConfiguration) throws IOException {
        BufferedImage bufferedImage = mxCellRenderer.createBufferedImage((mxGraph)graph, null, (double)1.0, (Color)Color.WHITE, (boolean)true, null);
        ImageIO.write((RenderedImage)bufferedImage, "PNG", imageFile);
        Path rootDir = Paths.get(reporterConfiguration.getRootDirectory(), new String[0]);
        Path relativize = rootDir.relativize(imageFile.toPath());
        return new FileEntry(relativize);
    }

    private ReportBuilder createDockerInfoGroup(DockerClientExecutor executor) {
        Version version = executor.dockerHostVersion();
        ReportBuilder reportBuilder = Reporter.createReport((StringKey)DockerEnvironmentReportKey.DOCKER_HOST_INFORMATION).addKeyValueEntry(DockerEnvironmentReportKey.DOCKER_VERSION, version.getVersion()).addKeyValueEntry(DockerEnvironmentReportKey.DOCKER_OS, version.getOperatingSystem()).addKeyValueEntry(DockerEnvironmentReportKey.DOCKER_KERNEL, version.getKernelVersion()).addKeyValueEntry(DockerEnvironmentReportKey.DOCKER_API_VERSION, version.getApiVersion()).addKeyValueEntry(DockerEnvironmentReportKey.DOCKER_ARCH, version.getArch());
        return reportBuilder;
    }

    private File createSchemasDirectory(File rootDirectory) {
        Path reportsSchema = Paths.get("reports", "schemas");
        Path schemasDir = rootDirectory.toPath().resolve(reportsSchema);
        try {
            Files.createDirectories(schemasDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Could not created schemas directory at %s", schemasDir));
        }
        return schemasDir.toFile();
    }

    private File createContainerLogDirectory(File rootDirectory) {
        Path reportsLogs = Paths.get("reports", "logs");
        Path logsDir = rootDirectory.toPath().resolve(reportsLogs);
        if (Files.notExists(logsDir, new LinkOption[0])) {
            try {
                Files.createDirectories(logsDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(String.format("Could not created logs directory at %s", logsDir));
            }
        }
        return logsDir.toFile();
    }

    private File createNetworkTopologyDirectory(File rootDirectory) {
        Path reportsNetworks = Paths.get("reports", "networks");
        Path networksDir = rootDirectory.toPath().resolve(reportsNetworks);
        try {
            Files.createDirectories(networksDir, new FileAttribute[0]);
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.format("Could not created networks directory at %s", networksDir));
        }
        return networksDir.toFile();
    }

    private String getHumanReadbale(Long bytes, Boolean decimal) {
        return NumberConversion.humanReadableByteCount(bytes, decimal);
    }
}

