/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.reporter;

import java.lang.reflect.Method;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.arquillian.cube.docker.drone.event.AfterVideoRecorded;
import org.arquillian.cube.docker.impl.client.reporter.DockerEnvironmentReportKey;
import org.arquillian.reporter.api.builder.Reporter;
import org.arquillian.reporter.api.builder.report.TestMethodReportBuilder;
import org.arquillian.reporter.api.event.SectionEvent;
import org.arquillian.reporter.api.event.TestMethodSection;
import org.arquillian.reporter.api.model.entry.Entry;
import org.arquillian.reporter.api.model.entry.FileEntry;
import org.arquillian.reporter.api.model.report.Report;
import org.arquillian.reporter.api.model.report.TestMethodReport;
import org.arquillian.reporter.config.ReporterConfiguration;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class TakeVncDroneVideo {
    @Inject
    Event<SectionEvent> reportEvent;

    public void reportScreencastRecording(@Observes AfterVideoRecorded event, ReporterConfiguration reporterConfiguration) {
        Path videoLocation = event.getVideoLocation();
        if (videoLocation != null) {
            videoLocation = Paths.get(videoLocation.toString().replace("flv", "mp4"), new String[0]);
            Path rootDir = Paths.get(reporterConfiguration.getRootDirectory(), new String[0]);
            Path relativize = rootDir.relativize(videoLocation);
            Method testMethod = this.getTestMethod(event);
            ((TestMethodReportBuilder)((TestMethodReportBuilder)Reporter.createReport((Report)new TestMethodReport(testMethod.getName()))).addKeyValueEntry(DockerEnvironmentReportKey.VIDEO_PATH, (Entry)new FileEntry(relativize))).inSection((SectionEvent)new TestMethodSection(testMethod)).fire(this.reportEvent);
        }
    }

    private Method getTestMethod(@Observes AfterVideoRecorded event) {
        return event.getAfter().getTestMethod();
    }
}

