/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.reporter;

import com.github.dockerjava.api.model.BlkioStatEntry;
import com.github.dockerjava.api.model.BlkioStatsConfig;
import com.github.dockerjava.api.model.MemoryStatsConfig;
import com.github.dockerjava.api.model.StatisticNetworksConfig;
import com.github.dockerjava.api.model.Statistics;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.arquillian.cube.docker.impl.client.reporter.CubeStatistics;

public class ContainerStatsBuilder {
    public static CubeStatistics updateStats(Statistics statistics) {
        CubeStatistics stats = new CubeStatistics();
        Map<String, Long> blkio = ContainerStatsBuilder.extractIORW(statistics.getBlkioStats());
        stats.setIoBytesRead(blkio.get("io_bytes_read"));
        stats.setIoBytesWrite(blkio.get("io_bytes_write"));
        MemoryStatsConfig memoryStats = statistics.getMemoryStats();
        stats.setMaxUsage(memoryStats.getMaxUsage());
        stats.setUsage(memoryStats.getUsage());
        stats.setLimit(memoryStats.getLimit());
        stats.setNetworks(ContainerStatsBuilder.extractNetworksStats(statistics.getNetworks()));
        return stats;
    }

    private static Map<String, Map<String, Long>> extractNetworksStats(Map<String, StatisticNetworksConfig> map) {
        LinkedHashMap<String, Map<String, Long>> nwStatsForEachNICAndTotal = new LinkedHashMap<String, Map<String, Long>>();
        if (map != null) {
            long totalRxBytes = 0L;
            long totalTxBytes = 0L;
            for (Map.Entry<String, StatisticNetworksConfig> entry : map.entrySet()) {
                LinkedHashMap<String, Long> nwStats = new LinkedHashMap<String, Long>();
                String adapterName = entry.getKey();
                StatisticNetworksConfig adapter = entry.getValue();
                long rxBytes = adapter.getRxBytes();
                long txBytes = adapter.getTxBytes();
                nwStats.put("rx_bytes", rxBytes);
                nwStats.put("tx_bytes", txBytes);
                nwStatsForEachNICAndTotal.put(adapterName, nwStats);
                totalRxBytes += rxBytes;
                totalTxBytes += txBytes;
            }
            LinkedHashMap<String, Long> total = new LinkedHashMap<String, Long>();
            total.put("rx_bytes", totalRxBytes);
            total.put("tx_bytes", totalTxBytes);
            nwStatsForEachNICAndTotal.put("Total", total);
        }
        return nwStatsForEachNICAndTotal;
    }

    private static Map<String, Long> extractIORW(BlkioStatsConfig blkioStats) {
        LinkedHashMap<String, Long> blkrwStats = new LinkedHashMap<String, Long>();
        if (blkioStats != null) {
            List bios = blkioStats.getIoServiceBytesRecursive();
            long read = 0L;
            long write = 0L;
            if (bios != null) {
                for (BlkioStatEntry blkioStatEntry : bios) {
                    if (blkioStatEntry == null) continue;
                    switch (blkioStatEntry.getOp()) {
                        case "Read": {
                            read = blkioStatEntry.getValue();
                            break;
                        }
                        case "Write": {
                            write = blkioStatEntry.getValue();
                        }
                    }
                }
            }
            blkrwStats.put("io_bytes_read", read);
            blkrwStats.put("io_bytes_write", write);
        }
        return blkrwStats;
    }
}

