/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.reporter;

import io.restassured.RestAssured;
import io.restassured.builder.ResponseBuilder;
import io.restassured.filter.Filter;
import io.restassured.filter.FilterContext;
import io.restassured.filter.log.LogDetail;
import io.restassured.internal.RestAssuredResponseImpl;
import io.restassured.internal.print.RequestPrinter;
import io.restassured.internal.print.ResponsePrinter;
import io.restassured.response.Response;
import io.restassured.response.ResponseBody;
import io.restassured.response.ResponseOptions;
import io.restassured.specification.FilterableRequestSpecification;
import io.restassured.specification.FilterableResponseSpecification;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import org.arquillian.cube.docker.impl.client.reporter.DockerEnvironmentReportKey;
import org.arquillian.cube.docker.impl.client.reporter.DockerLogSection;
import org.arquillian.cube.docker.restassured.RestAssuredConfiguration;
import org.arquillian.reporter.api.builder.Reporter;
import org.arquillian.reporter.api.event.SectionEvent;
import org.arquillian.reporter.api.model.StringKey;
import org.arquillian.reporter.api.model.entry.Entry;
import org.arquillian.reporter.api.model.entry.FileEntry;
import org.arquillian.reporter.config.ReporterConfiguration;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.core.api.annotation.Inject;
import org.jboss.arquillian.core.api.annotation.Observes;

public class TakeRestAssuredContent {
    @Inject
    Event<SectionEvent> reportEvent;

    public void registerFilterForRecorder(@Observes(precedence=-10) RestAssuredConfiguration restAssuredConfiguration, ReporterConfiguration reporterConfiguration) {
        RestAssured.filters((Filter)new TakeRequest(this.reportEvent, reporterConfiguration), (Filter[])new Filter[]{new TakeResponse(this.reportEvent, reporterConfiguration)});
    }

    private static File createLogDirectory(File rootDirectory) {
        Path reportsLogs = Paths.get("reports", "logs");
        Path logsDir = rootDirectory.toPath().resolve(reportsLogs);
        if (Files.notExists(logsDir, new LinkOption[0])) {
            try {
                Files.createDirectories(logsDir, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new IllegalArgumentException(String.format("Could not created logs directory at %s", logsDir));
            }
        }
        return logsDir.toFile();
    }

    private static void writeContent(ByteArrayOutputStream requestLog, File logFile) {
        try {
            Files.write(logFile.toPath(), requestLog.toByteArray(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static class TakeRequest
    implements Filter {
        private Event<SectionEvent> reportEvent;
        private ReporterConfiguration reporterConfiguration;

        public TakeRequest(Event<SectionEvent> reportEvent, ReporterConfiguration reporterConfiguration) {
            this.reportEvent = reportEvent;
            this.reporterConfiguration = reporterConfiguration;
        }

        public Response filter(FilterableRequestSpecification requestSpec, FilterableResponseSpecification responseSpec, FilterContext ctx) {
            String uri = requestSpec.getURI();
            uri = TakeRequest.urlDecode(uri, Charset.forName(requestSpec.getConfig().getEncoderConfig().defaultQueryParameterCharset()), true);
            ByteArrayOutputStream requestLog = new ByteArrayOutputStream();
            PrintStream stream = new PrintStream(requestLog);
            RequestPrinter.print((FilterableRequestSpecification)requestSpec, (String)requestSpec.getMethod(), (String)uri, (LogDetail)LogDetail.ALL, new HashSet(), (PrintStream)stream, (boolean)true);
            File logFile = new File(TakeRestAssuredContent.createLogDirectory(new File(this.reporterConfiguration.getRootDirectory())), "restassuredRequest.log");
            TakeRestAssuredContent.writeContent(requestLog, logFile);
            Path rootDir = Paths.get(this.reporterConfiguration.getRootDirectory(), new String[0]);
            Path relativePath = rootDir.relativize(logFile.toPath());
            Reporter.createReport((StringKey)DockerEnvironmentReportKey.REST_REQUEST_LOG).addKeyValueEntry(DockerEnvironmentReportKey.LOG_PATH, (Entry)new FileEntry(relativePath)).inSection((SectionEvent)new DockerLogSection()).fire(this.reportEvent);
            return ctx.next(requestSpec, responseSpec);
        }

        private static String urlDecode(String content, Charset charset, boolean plusAsBlank) {
            if (content == null) {
                return null;
            }
            ByteBuffer bb = ByteBuffer.allocate(content.length());
            CharBuffer cb = CharBuffer.wrap(content);
            while (cb.hasRemaining()) {
                char c = cb.get();
                if (c == '%' && cb.remaining() >= 2) {
                    char uc = cb.get();
                    char lc = cb.get();
                    int u = Character.digit(uc, 16);
                    int l = Character.digit(lc, 16);
                    if (u != -1 && l != -1) {
                        bb.put((byte)((u << 4) + l));
                        continue;
                    }
                    bb.put((byte)37);
                    bb.put((byte)uc);
                    bb.put((byte)lc);
                    continue;
                }
                if (plusAsBlank && c == '+') {
                    bb.put((byte)32);
                    continue;
                }
                bb.put((byte)c);
            }
            bb.flip();
            return charset.decode(bb).toString();
        }
    }

    public static class TakeResponse
    implements Filter {
        private Event<SectionEvent> reportEvent;
        private ReporterConfiguration reporterConfiguration;

        public TakeResponse(Event<SectionEvent> reportEvent, ReporterConfiguration reporterConfiguration) {
            this.reportEvent = reportEvent;
            this.reporterConfiguration = reporterConfiguration;
        }

        public Response filter(FilterableRequestSpecification requestSpec, FilterableResponseSpecification responseSpec, FilterContext ctx) {
            Response response = ctx.next(requestSpec, responseSpec);
            ByteArrayOutputStream responseLog = new ByteArrayOutputStream();
            PrintStream stream = new PrintStream(responseLog);
            ResponsePrinter.print((ResponseOptions)response, (ResponseBody)response, (PrintStream)stream, (LogDetail)LogDetail.ALL, (boolean)true, new HashSet());
            File logFile = new File(TakeRestAssuredContent.createLogDirectory(new File(this.reporterConfiguration.getRootDirectory())), "restassuredResponse.log");
            TakeRestAssuredContent.writeContent(responseLog, logFile);
            Path rootDir = Paths.get(this.reporterConfiguration.getRootDirectory(), new String[0]);
            Path relativePath = rootDir.relativize(logFile.toPath());
            Reporter.createReport((StringKey)DockerEnvironmentReportKey.REST_RESPONSE_LOG).addKeyValueEntry(DockerEnvironmentReportKey.LOG_PATH, (Entry)new FileEntry(relativePath)).inSection((SectionEvent)new DockerLogSection()).fire(this.reportEvent);
            byte[] responseBody = response.asByteArray();
            return this.cloneResponseIfNeeded(response, responseBody);
        }

        private Response cloneResponseIfNeeded(Response response, byte[] responseAsString) {
            if (responseAsString != null && response instanceof RestAssuredResponseImpl && !((RestAssuredResponseImpl)response).getHasExpectations()) {
                Response build = new ResponseBuilder().clone(response).setBody(responseAsString).build();
                ((RestAssuredResponseImpl)build).setHasExpectations(true);
                return build;
            }
            return response;
        }
    }
}

