/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.reporter;

import com.github.dockerjava.api.model.BlkioStatEntry;
import com.github.dockerjava.api.model.BlkioStatsConfig;
import com.github.dockerjava.api.model.MemoryStatsConfig;
import com.github.dockerjava.api.model.StatisticNetworksConfig;
import com.github.dockerjava.api.model.Statistics;
import com.github.dockerjava.api.model.StatsConfig;
import com.github.dockerjava.api.model.Version;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.arquillian.cube.docker.impl.client.CubeDockerConfiguration;
import org.arquillian.cube.docker.impl.client.DefinitionFormat;
import org.arquillian.cube.docker.impl.client.reporter.DockerEnvironmentReportKey;
import org.arquillian.cube.docker.impl.client.reporter.TakeDockerEnvironment;
import org.arquillian.cube.docker.impl.docker.DockerClientExecutor;
import org.arquillian.cube.impl.model.LocalCubeRegistry;
import org.arquillian.cube.remote.requirement.RequiresRemoteResource;
import org.arquillian.cube.spi.Cube;
import org.arquillian.cube.spi.CubeRegistry;
import org.arquillian.cube.spi.event.lifecycle.AfterAutoStart;
import org.arquillian.cube.spi.event.lifecycle.BeforeStop;
import org.arquillian.reporter.api.builder.BuilderLoader;
import org.arquillian.reporter.api.event.SectionEvent;
import org.arquillian.reporter.api.event.Standalone;
import org.arquillian.reporter.api.model.entry.Entry;
import org.arquillian.reporter.api.model.entry.FileEntry;
import org.arquillian.reporter.api.model.entry.KeyValueEntry;
import org.arquillian.reporter.api.model.report.BasicReport;
import org.arquillian.reporter.api.model.report.Report;
import org.arquillian.reporter.config.ReporterConfiguration;
import org.arquillian.reporter.impl.asserts.BasicReportAssert;
import org.arquillian.reporter.impl.asserts.ReportAssert;
import org.arquillian.reporter.impl.asserts.SectionAssert;
import org.jboss.arquillian.core.api.Event;
import org.junit.Before;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
@Category(value={RequiresRemoteResource.class})
public class TakeDockerEnvironmentTest {
    private static final String MULTIPLE_PORT_BINDING_SCENARIO = "helloworld:\n  image: dockercloud/hello-world\n  exposedPorts: [8089/tcp]\n  networkMode: host\n  portBindings: [8080->80/tcp, 8081->81/tcp]";
    private static final String CUBE_ID = "tomcat";
    @Mock
    DockerClientExecutor dockerClientExecutor;
    @Mock
    Version version;
    @Mock
    Event<SectionEvent> reportEvent;
    @Mock
    private Cube cube;
    @Captor
    ArgumentCaptor<SectionEvent> reportEventArgumentCaptor;
    private CubeRegistry cubeRegistry;
    @Mock
    private Statistics statistics;

    @Before
    public void setUpCubeDockerExecutorAndBuilder() throws IOException {
        this.configureDockerExecutor();
        this.configureCube();
        BuilderLoader.load();
    }

    private void configureDockerExecutor() {
        Mockito.when((Object)this.version.getVersion()).thenReturn((Object)"1.1.0");
        Mockito.when((Object)this.version.getOperatingSystem()).thenReturn((Object)"linux");
        Mockito.when((Object)this.version.getKernelVersion()).thenReturn((Object)"3.1.0");
        Mockito.when((Object)this.version.getApiVersion()).thenReturn((Object)"1.12");
        Mockito.when((Object)this.version.getArch()).thenReturn((Object)"x86");
        Mockito.when((Object)this.dockerClientExecutor.dockerHostVersion()).thenReturn((Object)this.version);
        Mockito.lenient().when((Object)this.dockerClientExecutor.isDockerInsideDockerResolution()).thenReturn((Object)true);
    }

    private void configureCube() throws IOException {
        this.cubeRegistry = new LocalCubeRegistry();
        Mockito.when((Object)this.cube.getId()).thenReturn((Object)CUBE_ID);
        this.cubeRegistry.addCube(this.cube);
        Map<String, StatisticNetworksConfig> networks = this.getNetworks();
        Mockito.lenient().when((Object)this.statistics.getNetworks()).thenReturn(networks);
        MemoryStatsConfig memory = this.getMemory();
        Mockito.lenient().when((Object)this.statistics.getMemoryStats()).thenReturn((Object)memory);
        BlkioStatsConfig ioStats = this.getIOStats();
        Mockito.lenient().when((Object)this.statistics.getBlkioStats()).thenReturn((Object)ioStats);
        Mockito.lenient().when((Object)this.dockerClientExecutor.statsContainer(CUBE_ID)).thenReturn((Object)this.statistics);
    }

    private void createTakeDockerEnvironmentAndreportDockerEnvironment() {
        TakeDockerEnvironment takeDockerEnvironment = new TakeDockerEnvironment();
        takeDockerEnvironment.reportEvent = this.reportEvent;
        HashMap<String, String> configuration = new HashMap<String, String>();
        configuration.put("dockerContainers", MULTIPLE_PORT_BINDING_SCENARIO);
        configuration.put("definitionFormat", DefinitionFormat.CUBE.name());
        takeDockerEnvironment.reportDockerEnvironment(new AfterAutoStart(), CubeDockerConfiguration.fromMap(configuration, null), this.dockerClientExecutor, this.getReporterConfiguration());
    }

    @Test
    public void should_report_docker_info() {
        this.createTakeDockerEnvironmentAndreportDockerEnvironment();
        ((Event)Mockito.verify(this.reportEvent)).fire((Object)((SectionEvent)this.reportEventArgumentCaptor.capture()));
        SectionEvent sectionEvent = (SectionEvent)this.reportEventArgumentCaptor.getValue();
        SectionAssert.assertThatSection((SectionEvent)sectionEvent).hasSectionId(Standalone.getStandaloneId()).hasReportOfTypeThatIsAssignableFrom(BasicReport.class);
        Report report = sectionEvent.getReport();
        List subReports = report.getSubReports();
        ((BasicReportAssert)((BasicReportAssert)ReportAssert.assertThatReport((Report)((Report)subReports.get(0))).hasName(DockerEnvironmentReportKey.DOCKER_HOST_INFORMATION)).hasNumberOfEntries(5)).hasEntriesContaining(new Entry[]{new KeyValueEntry(DockerEnvironmentReportKey.DOCKER_VERSION, "1.1.0"), new KeyValueEntry(DockerEnvironmentReportKey.DOCKER_OS, "linux"), new KeyValueEntry(DockerEnvironmentReportKey.DOCKER_KERNEL, "3.1.0"), new KeyValueEntry(DockerEnvironmentReportKey.DOCKER_API_VERSION, "1.12"), new KeyValueEntry(DockerEnvironmentReportKey.DOCKER_ARCH, "x86")});
    }

    @Test
    public void should_report_schema_of_docker_composition_and_network_topology() {
        this.createTakeDockerEnvironmentAndreportDockerEnvironment();
        ((Event)Mockito.verify(this.reportEvent)).fire((Object)((SectionEvent)this.reportEventArgumentCaptor.capture()));
        SectionEvent sectionEvent = (SectionEvent)this.reportEventArgumentCaptor.getValue();
        SectionAssert.assertThatSection((SectionEvent)sectionEvent).hasSectionId(Standalone.getStandaloneId()).hasReportOfTypeThatIsAssignableFrom(BasicReport.class);
        Report report = sectionEvent.getReport();
        ((BasicReportAssert)((BasicReportAssert)ReportAssert.assertThatReport((Report)report).hasName(DockerEnvironmentReportKey.DOCKER_ENVIRONMENT)).hasNumberOfSubReports(1)).hasEntriesContaining(new Entry[]{new KeyValueEntry(DockerEnvironmentReportKey.DOCKER_COMPOSITION_SCHEMA, (Entry)new FileEntry("reports" + File.separatorChar + "schemas" + File.separatorChar + "docker_composition.png")), new KeyValueEntry(DockerEnvironmentReportKey.NETWORK_TOPOLOGY_SCHEMA, (Entry)new FileEntry("reports" + File.separatorChar + "networks" + File.separatorChar + "docker_network_topology.png"))});
    }

    @Test
    public void should_report_log_file() throws IOException {
        TakeDockerEnvironment takeDockerEnvironment = new TakeDockerEnvironment();
        takeDockerEnvironment.reportEvent = this.reportEvent;
        takeDockerEnvironment.reportContainerLogs(new BeforeStop(CUBE_ID), this.dockerClientExecutor, this.getReporterConfiguration());
        ((Event)Mockito.verify(this.reportEvent)).fire((Object)((SectionEvent)this.reportEventArgumentCaptor.capture()));
        SectionEvent sectionEvent = (SectionEvent)this.reportEventArgumentCaptor.getValue();
        SectionAssert.assertThatSection((SectionEvent)sectionEvent).hasSectionId(CUBE_ID).hasReportOfTypeThatIsAssignableFrom(BasicReport.class);
        Report report = sectionEvent.getReport();
        ((BasicReportAssert)ReportAssert.assertThatReport((Report)report).hasNumberOfEntries(1)).hasEntriesContaining(new Entry[]{new KeyValueEntry(DockerEnvironmentReportKey.LOG_PATH, (Entry)new FileEntry("reports" + File.separatorChar + "logs" + File.separatorChar + "tomcat.log"))});
    }

    private ReporterConfiguration getReporterConfiguration() {
        return ReporterConfiguration.fromMap(new LinkedHashMap());
    }

    private Map<String, StatisticNetworksConfig> getNetworks() {
        LinkedHashMap<String, StatisticNetworksConfig> nw = new LinkedHashMap<String, StatisticNetworksConfig>();
        StatisticNetworksConfig bytes = (StatisticNetworksConfig)Mockito.mock(StatisticNetworksConfig.class);
        Mockito.lenient().when((Object)bytes.getRxBytes()).thenReturn((Object)724L);
        Mockito.lenient().when((Object)bytes.getTxBytes()).thenReturn((Object)418L);
        Mockito.lenient().when((Object)bytes.getRxPackets()).thenReturn((Object)19L);
        nw.put("eth0", bytes);
        return nw;
    }

    private MemoryStatsConfig getMemory() {
        MemoryStatsConfig memory = (MemoryStatsConfig)Mockito.mock(MemoryStatsConfig.class);
        Mockito.lenient().when((Object)memory.getUsage()).thenReturn((Object)35135488L);
        Mockito.lenient().when((Object)memory.getMaxUsage()).thenReturn((Object)35770368L);
        Mockito.lenient().when((Object)memory.getLimit()).thenReturn((Object)20444532736L);
        Mockito.lenient().when((Object)memory.getStats()).thenReturn((Object)new StatsConfig());
        return memory;
    }

    private BlkioStatsConfig getIOStats() {
        BlkioStatsConfig blkIO = (BlkioStatsConfig)Mockito.mock(BlkioStatsConfig.class);
        ArrayList<BlkioStatEntry> io = new ArrayList<BlkioStatEntry>();
        BlkioStatEntry ioServiceRead = new BlkioStatEntry().withMajor(Long.valueOf(7L)).withMajor(Long.valueOf(0L)).withOp("Read").withValue(Long.valueOf(50688L));
        io.add(ioServiceRead);
        BlkioStatEntry ioServiceWrite = new BlkioStatEntry().withMajor(Long.valueOf(7L)).withMajor(Long.valueOf(0L)).withOp("Write").withValue(Long.valueOf(0L));
        io.add(ioServiceWrite);
        BlkioStatEntry ioServiceSync = new BlkioStatEntry().withMajor(Long.valueOf(7L)).withMinor(Long.valueOf(0L)).withOp("Sync").withValue(Long.valueOf(0L));
        io.add(ioServiceSync);
        Mockito.lenient().when((Object)blkIO.getIoServiceBytesRecursive()).thenReturn(io);
        Mockito.lenient().when((Object)blkIO.getIoTimeRecursive()).thenReturn(new ArrayList());
        return blkIO;
    }
}

