/*
 * Decompiled with CFR 0.152.
 */
package org.arquillian.cube.docker.impl.client.reporter;

import java.io.File;
import java.lang.reflect.Method;
import java.nio.file.Paths;
import java.util.LinkedHashMap;
import org.arquillian.cube.docker.drone.event.AfterVideoRecorded;
import org.arquillian.cube.docker.impl.client.reporter.DockerEnvironmentReportKey;
import org.arquillian.cube.docker.impl.client.reporter.TakeDockerEnvironmentTest;
import org.arquillian.cube.docker.impl.client.reporter.TakeVncDroneVideo;
import org.arquillian.reporter.api.builder.BuilderLoader;
import org.arquillian.reporter.api.event.SectionEvent;
import org.arquillian.reporter.api.model.entry.Entry;
import org.arquillian.reporter.api.model.entry.FileEntry;
import org.arquillian.reporter.api.model.entry.KeyValueEntry;
import org.arquillian.reporter.api.model.report.Report;
import org.arquillian.reporter.api.model.report.TestMethodReport;
import org.arquillian.reporter.config.ReporterConfiguration;
import org.arquillian.reporter.impl.asserts.BasicReportAssert;
import org.arquillian.reporter.impl.asserts.ReportAssert;
import org.arquillian.reporter.impl.asserts.SectionAssert;
import org.jboss.arquillian.core.api.Event;
import org.jboss.arquillian.test.spi.event.suite.After;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.ArgumentCaptor;
import org.mockito.Captor;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;

@RunWith(value=MockitoJUnitRunner.class)
public class TakeVncDroneVideoTest {
    @Mock
    Event<SectionEvent> reportEvent;
    @Captor
    ArgumentCaptor<SectionEvent> reportEventArgumentCaptor;

    @Before
    public void setUp() {
        BuilderLoader.load();
    }

    @Test
    public void should_create_video_from_root_directory() throws NoSuchMethodException {
        TakeVncDroneVideo takeVncDroneVideo = new TakeVncDroneVideo();
        takeVncDroneVideo.reportEvent = this.reportEvent;
        Method method = this.getMethod("should_create_video_from_root_directory");
        AfterVideoRecorded afterVideoRecorded = new AfterVideoRecorded(new After(TakeDockerEnvironmentTest.class, method), Paths.get("target/myvideo.flv", new String[0]));
        takeVncDroneVideo.reportScreencastRecording(afterVideoRecorded, this.getReporterConfiguration());
        ((Event)Mockito.verify(this.reportEvent)).fire((Object)((SectionEvent)this.reportEventArgumentCaptor.capture()));
        SectionEvent sectionEvent = (SectionEvent)this.reportEventArgumentCaptor.getValue();
        String methodName = method.getName();
        SectionAssert.assertThatSection((SectionEvent)sectionEvent).hasSectionId(methodName).hasReportOfTypeThatIsAssignableFrom(TestMethodReport.class);
        Report report = sectionEvent.getReport();
        ((BasicReportAssert)((BasicReportAssert)ReportAssert.assertThatReport((Report)report).hasName(methodName)).hasNumberOfEntries(1)).hasEntriesContaining(new Entry[]{new KeyValueEntry(DockerEnvironmentReportKey.VIDEO_PATH, (Entry)new FileEntry("myvideo.mp4"))});
    }

    @Test
    public void should_create_video_from_surefire_report_directory() throws NoSuchMethodException {
        TakeVncDroneVideo takeVncDroneVideo = new TakeVncDroneVideo();
        takeVncDroneVideo.reportEvent = this.reportEvent;
        Method method = this.getMethod("should_create_video_from_surefire_report_directory");
        AfterVideoRecorded afterVideoRecorded = new AfterVideoRecorded(new After(TakeDockerEnvironmentTest.class, method), Paths.get("target/surefire-report/myvideo.flv", new String[0]));
        takeVncDroneVideo.reportScreencastRecording(afterVideoRecorded, this.getReporterConfiguration());
        ((Event)Mockito.verify(this.reportEvent)).fire((Object)((SectionEvent)this.reportEventArgumentCaptor.capture()));
        SectionEvent sectionEvent = (SectionEvent)this.reportEventArgumentCaptor.getValue();
        String methodName = method.getName();
        SectionAssert.assertThatSection((SectionEvent)sectionEvent).hasSectionId(methodName).hasReportOfTypeThatIsAssignableFrom(TestMethodReport.class);
        Report report = sectionEvent.getReport();
        ((BasicReportAssert)((BasicReportAssert)ReportAssert.assertThatReport((Report)report).hasName(methodName)).hasNumberOfEntries(1)).hasEntriesContaining(new Entry[]{new KeyValueEntry(DockerEnvironmentReportKey.VIDEO_PATH, (Entry)new FileEntry("surefire-report" + File.separatorChar + "myvideo.mp4"))});
    }

    private ReporterConfiguration getReporterConfiguration() {
        return ReporterConfiguration.fromMap(new LinkedHashMap());
    }

    private Method getMethod(String name) throws NoSuchMethodException {
        return TakeVncDroneVideoTest.class.getMethod(name, new Class[0]);
    }
}

